/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el;

import net.flare.el.LoginManager;
import net.flare.el.commands.AdminForceChangePassCommand;
import net.flare.el.commands.AdminReloadCommand;
import net.flare.el.commands.PlayerChangePassCommand;
import net.flare.el.commands.PlayerLoginCommand;
import net.flare.el.commands.PlayerRegisterCommand;
import net.flare.el.database.DatabaseManager;
import net.flare.el.database.UserRepository;
import net.flare.el.listeners.PlayerChatListener;
import net.flare.el.listeners.PlayerJoinListener;
import net.flare.el.listeners.PlayerMoveListener;
import net.flare.el.listeners.PlayerQuitListener;
import net.flare.el.util.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class EpicLogin
extends JavaPlugin {
    private DatabaseManager databaseManager;
    private UserRepository userRepository;
    private ConfigManager messagesConfig;
    private ConfigManager configManager;
    private LoginManager loginManager;
    private int serverId = 1;

    public void onEnable() {
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this, "config.yml");
        this.messagesConfig = new ConfigManager(this, "messages.yml");
        String dbType = this.getConfig().getString("database.type", "sqlite").toLowerCase();
        try {
            if (dbType.equals("mysql")) {
                String host = this.getConfig().getString("database.host");
                int port = this.getConfig().getInt("database.port");
                String name = this.getConfig().getString("database.name");
                String user = this.getConfig().getString("database.user");
                String password = this.getConfig().getString("database.password");
                String url = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&autoReconnect=true", host, port, name);
                this.databaseManager = new DatabaseManager(this, url, user, password);
            } else {
                String file = this.getConfig().getString("database.file", "epiclogin.db");
                String url = "jdbc:sqlite:" + this.getDataFolder().getAbsolutePath() + "/" + file;
                this.databaseManager = new DatabaseManager(this, url);
            }
            this.databaseManager.connect();
        }
        catch (Exception e) {
            this.getLogger().severe("Could not connect to the database!");
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.userRepository = new UserRepository(this.databaseManager);
        this.loginManager = new LoginManager(this);
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("EpicLogin enabled!");
    }

    private void registerCommands() {
        this.getCommand("login").setExecutor((CommandExecutor)new PlayerLoginCommand(this, this.userRepository));
        this.getCommand("register").setExecutor((CommandExecutor)new PlayerRegisterCommand(this, this.userRepository));
        this.getCommand("changepass").setExecutor((CommandExecutor)new PlayerChangePassCommand(this, this.userRepository));
        this.getCommand("forcechangepass").setExecutor((CommandExecutor)new AdminForceChangePassCommand(this, this.userRepository));
        this.getCommand("epiclogin").setExecutor((CommandExecutor)new AdminReloadCommand(this));
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerQuitListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerMoveListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
    }

    public void onDisable() {
        try {
            this.databaseManager.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getLogger().info("EpicLogin disabled!");
    }

    public ConfigManager getMessagesConfig() {
        return this.messagesConfig;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public int getServerId() {
        return this.serverId;
    }
}

