/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.flare.el.EpicLogin;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LoginManager {
    private final EpicLogin plugin;
    private final Map<UUID, Integer> attemptsLeft = new HashMap<UUID, Integer>();
    private final Map<UUID, BukkitTask> kickTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Boolean> loggedIn = new HashMap<UUID, Boolean>();
    private final int maxAttempts;
    private final int loginTimeSeconds;

    public LoginManager(EpicLogin plugin) {
        this.plugin = plugin;
        this.maxAttempts = plugin.getConfig().getInt("login.max_attempts", 5);
        this.loginTimeSeconds = plugin.getConfig().getInt("login.timer", 60);
    }

    public void startLoginSession(Player player) {
        UUID uuid = player.getUniqueId();
        this.attemptsLeft.put(uuid, this.maxAttempts);
        this.loggedIn.put(uuid, false);
        this.scheduleKickTask(player);
    }

    public void endLoginSession(Player player) {
        UUID uuid = player.getUniqueId();
        this.attemptsLeft.remove(uuid);
        this.loggedIn.remove(uuid);
        this.cancelKickTask(uuid);
    }

    public void markPlayerLoggedIn(Player player) {
        UUID uuid = player.getUniqueId();
        this.loggedIn.put(uuid, true);
        this.cancelKickTask(uuid);
    }

    public boolean isLoggedIn(Player player) {
        return this.loggedIn.getOrDefault(player.getUniqueId(), false);
    }

    public int decrementAttempts(Player player) {
        UUID uuid = player.getUniqueId();
        int attempts = this.attemptsLeft.getOrDefault(uuid, this.maxAttempts);
        attempts = Math.max(attempts - 1, 0);
        this.attemptsLeft.put(uuid, attempts);
        return attempts;
    }

    public int getAttemptsLeft(Player player) {
        return this.attemptsLeft.getOrDefault(player.getUniqueId(), this.maxAttempts);
    }

    private void scheduleKickTask(Player player) {
        UUID uuid = player.getUniqueId();
        BukkitTask existing = this.kickTasks.get(uuid);
        if (existing != null) {
            existing.cancel();
        }
        int timeSeconds = this.loginTimeSeconds;
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (!this.isLoggedIn(player)) {
                player.kickPlayer(this.plugin.getConfig().getString("login.kick_message"));
            }
        }, (long)timeSeconds * 20L);
        this.kickTasks.put(uuid, task);
    }

    private void cancelKickTask(UUID uuid) {
        BukkitTask task = this.kickTasks.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }
}

