/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.commands;

import net.flare.el.EpicLogin;
import net.flare.el.database.UserRepository;
import net.flare.el.util.MessageUtil;
import net.flare.el.util.SecurityUtil;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminForceChangePassCommand
implements CommandExecutor {
    private final EpicLogin plugin;
    private final UserRepository userRepository;

    public AdminForceChangePassCommand(EpicLogin plugin, UserRepository userRepository) {
        this.plugin = plugin;
        this.userRepository = userRepository;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("epiclogin.admin")) {
            sender.sendMessage("&cYou do not have permission to use this command.");
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("&cUsage: /forcechangepass <player> <newpassword>");
            return true;
        }
        String targetName = args[0];
        String newPassword = args[1];
        Player target = Bukkit.getPlayerExact((String)targetName);
        try {
            if (target == null) {
                sender.sendMessage("&cPlayer '" + targetName + "' not found.");
                return true;
            }
            String hashedPassword = SecurityUtil.hashPassword(newPassword);
            this.userRepository.updatePassword(target.getUniqueId().toString(), hashedPassword);
            sender.sendMessage(this.plugin.getMessagesConfig().getString("admin.password_reset").replace("{player}", targetName));
            MessageUtil.sendMessage((CommandSender)target, this.plugin.getMessagesConfig().getString("admin.password_reset_notify"));
        }
        catch (Exception ex) {
            sender.sendMessage("&cAn error occurred resetting the password.");
            ex.printStackTrace();
        }
        return true;
    }
}

