/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.commands;

import net.flare.el.EpicLogin;
import net.flare.el.database.UserRepository;
import net.flare.el.util.MessageUtil;
import net.flare.el.util.SecurityUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerChangePassCommand
implements CommandExecutor {
    private final EpicLogin plugin;
    private final UserRepository userRepository;

    public PlayerChangePassCommand(EpicLogin plugin, UserRepository userRepository) {
        this.plugin = plugin;
        this.userRepository = userRepository;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("epiclogin.use")) {
            MessageUtil.sendMessage((CommandSender)player, "&cYou do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            MessageUtil.sendMessage((CommandSender)player, "&cUsage: /changepass <newpassword>");
            return true;
        }
        String newPassword = args[0];
        try {
            String hashedPassword = SecurityUtil.hashPassword(newPassword);
            this.userRepository.updatePassword(player.getUniqueId().toString(), hashedPassword);
            MessageUtil.sendMessage((CommandSender)player, this.plugin.getMessagesConfig().getString("changepass.success"));
        }
        catch (Exception ex) {
            MessageUtil.sendMessage((CommandSender)player, this.plugin.getMessagesConfig().getString("changepass.failure"));
            ex.printStackTrace();
        }
        return true;
    }
}

