/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.commands;

import net.flare.el.EpicLogin;
import net.flare.el.database.UserRepository;
import net.flare.el.util.MessageUtil;
import net.flare.el.util.SecurityUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PlayerLoginCommand
implements CommandExecutor {
    private final EpicLogin plugin;
    private final UserRepository userRepository;

    public PlayerLoginCommand(EpicLogin plugin, UserRepository userRepository) {
        this.plugin = plugin;
        this.userRepository = userRepository;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can execute this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("epiclogin.use")) {
            MessageUtil.sendMessage((CommandSender)player, "&cYou do not have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            MessageUtil.sendMessage((CommandSender)player, "&cUsage: /login <password>");
            return true;
        }
        String password = args[0];
        try {
            if (!this.userRepository.isUserRegistered(player.getUniqueId().toString())) {
                MessageUtil.sendMessage((CommandSender)player, this.plugin.getMessagesConfig().getString("misc.not_registered"));
                return true;
            }
            String hashedInputPassword = SecurityUtil.hashPassword(password);
            boolean valid = this.userRepository.validateLogin(player.getUniqueId().toString(), hashedInputPassword);
            if (valid) {
                this.plugin.getLoginManager().markPlayerLoggedIn(player);
                MessageUtil.sendMessage((CommandSender)player, this.plugin.getMessagesConfig().getString("login.success").replace("{player}", player.getName()));
            } else {
                this.plugin.getLoginManager().decrementAttempts(player);
                int attemptsLeft = this.plugin.getLoginManager().getAttemptsLeft(player);
                if (attemptsLeft <= 0) {
                    player.kickPlayer(this.plugin.getConfig().getString("login.kick_message"));
                } else {
                    MessageUtil.sendMessage((CommandSender)player, this.plugin.getMessagesConfig().getString("login.failure") + " &cAttempts left: " + attemptsLeft);
                }
            }
        }
        catch (Exception ex) {
            MessageUtil.sendMessage((CommandSender)player, "&cAn error occurred during login. Please try again later.");
            ex.printStackTrace();
        }
        return true;
    }
}

