/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private Connection connection;
    private final String url;
    private final String user;
    private final String password;
    private final boolean isMySQL;
    private final JavaPlugin plugin;

    public DatabaseManager(JavaPlugin plugin, String url, String user, String password) {
        this.plugin = plugin;
        this.url = url;
        this.user = user;
        this.password = password;
        this.isMySQL = url.startsWith("jdbc:mysql");
    }

    public DatabaseManager(JavaPlugin plugin, String url) {
        this(plugin, url, null, null);
    }

    public synchronized void connect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        this.connection = this.isMySQL ? DriverManager.getConnection(this.url, this.user, this.password) : DriverManager.getConnection(this.url);
        this.plugin.getLogger().info("Connected to database!");
        this.initTables();
    }

    public synchronized void disconnect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
            this.plugin.getLogger().info("Disconnected from database.");
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connect();
        }
        return this.connection;
    }

    private void initTables() throws SQLException {
        String userTable = "CREATE TABLE IF NOT EXISTS users (id INTEGER PRIMARY KEY AUTO_INCREMENT,uuid VARCHAR(36) NOT NULL UNIQUE,username VARCHAR(32) NOT NULL,hashed_password VARCHAR(255) NOT NULL,server_id INTEGER NOT NULL,last_ip VARCHAR(45),registered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
        String serverTable = "CREATE TABLE IF NOT EXISTS servers (id INTEGER PRIMARY KEY AUTO_INCREMENT,name VARCHAR(64) NOT NULL UNIQUE);";
        try (Statement stmt = this.getConnection().createStatement();){
            stmt.execute(userTable.replace("AUTO_INCREMENT", this.isMySQL ? "AUTO_INCREMENT" : "AUTOINCREMENT").replace("VARCHAR", this.isMySQL ? "VARCHAR" : "TEXT").replace("TIMESTAMP DEFAULT CURRENT_TIMESTAMP", this.isMySQL ? "TIMESTAMP DEFAULT CURRENT_TIMESTAMP" : "DATETIME DEFAULT CURRENT_TIMESTAMP"));
            stmt.execute(serverTable.replace("AUTO_INCREMENT", this.isMySQL ? "AUTO_INCREMENT" : "AUTOINCREMENT").replace("VARCHAR", this.isMySQL ? "VARCHAR" : "TEXT"));
        }
        this.plugin.getLogger().info("Database tables ensured.");
    }
}

