/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.util;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private final String fileName;
    private File file;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin, String fileName) {
        this.plugin = plugin;
        this.fileName = fileName;
        this.loadConfig();
    }

    public void loadConfig() {
        this.file = new File(this.plugin.getDataFolder(), this.fileName);
        if (!this.file.exists()) {
            this.plugin.saveResource(this.fileName, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        this.loadConfig();
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save " + this.fileName);
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getString(String path) {
        return this.config.getString(path);
    }
}

