/*
 * Decompiled with CFR 0.152.
 */
package net.flare.el.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.IntConsumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class TimerUtil {
    private final Plugin plugin;
    private final Map<UUID, BukkitTask> timers = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Integer> secondsLeft = new HashMap<UUID, Integer>();

    public TimerUtil(Plugin plugin) {
        this.plugin = plugin;
    }

    public void startTimer(Player player, int timeSeconds, Runnable onComplete, IntConsumer onTick) {
        UUID uuid = player.getUniqueId();
        this.cancelTimer(player);
        this.secondsLeft.put(uuid, timeSeconds);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            int left = this.secondsLeft.get(uuid);
            this.secondsLeft.put(uuid, --left);
            onTick.accept(left);
            if (left <= 0) {
                this.cancelTimer(player);
                onComplete.run();
            }
        }, 20L, 20L);
        this.timers.put(uuid, task);
    }

    public void cancelTimer(Player player) {
        UUID uuid = player.getUniqueId();
        BukkitTask task = this.timers.remove(uuid);
        this.secondsLeft.remove(uuid);
        if (task != null) {
            task.cancel();
        }
    }

    public int getSecondsLeft(Player player) {
        return this.secondsLeft.getOrDefault(player.getUniqueId(), 0);
    }
}

