/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter;

import com.github.blackjack200.ouranos.data.AbstractMapping;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.BlockStateUpdaters;
import com.github.blackjack200.ouranos.shaded.fastutil.ints.Int2ObjectRBTreeMap;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.utils.HashUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;

public final class BlockStateDictionary
extends AbstractMapping {
    private static final Map<Integer, Dictionary> entries = new ConcurrentHashMap<Integer, Dictionary>();

    public static NbtMap hackedUpgradeBlockState(NbtMap tag, int version) {
        return BlockStateDictionary.fixBlockStateUpdaterIssue(BlockStateUpdaters.updateBlockState(tag, version));
    }

    private static NbtMap fixBlockStateUpdaterIssue(NbtMap state) {
        return state;
    }

    public static Dictionary getInstance(int protocol) {
        return entries.computeIfAbsent(protocol, Dictionary::load);
    }

    public static final class Dictionary {
        private final Map<Integer, BlockEntry> currentStateHashToEntry;
        private final Map<Integer, BlockEntry> latestStateHashToEntry;
        private final Map<Integer, Integer> latestStateHashToCurrent;
        private final Map<Integer, Integer> latestStateHashToRuntimeId;
        private final Map<Integer, Integer> runtimeToLatestStateHash;
        private Integer fallbackRuntimeId;
        private final List<BlockEntry> knownStates;

        public Dictionary(Int2ObjectRBTreeMap<BlockEntry> states) {
            this.knownStates = states.values().stream().toList();
            this.currentStateHashToEntry = new Int2ObjectRBTreeMap<BlockEntry>();
            this.latestStateHashToEntry = new Int2ObjectRBTreeMap<BlockEntry>();
            this.latestStateHashToCurrent = new Int2ObjectRBTreeMap<Integer>();
            this.latestStateHashToRuntimeId = new Int2ObjectRBTreeMap<Integer>();
            this.runtimeToLatestStateHash = new Int2ObjectRBTreeMap<Integer>();
            int stateIdMax = states.size();
            for (int runtimeId = 0; runtimeId < stateIdMax; ++runtimeId) {
                BlockEntry entry = states.get(runtimeId);
                this.register(runtimeId, entry);
            }
            for (Map.Entry<Integer, BlockEntry> v : this.latestStateHashToEntry.entrySet()) {
                if (!v.getValue().name.equals("minecraft:info_update")) continue;
                this.fallbackRuntimeId = this.toRuntimeId(v.getKey());
                break;
            }
            if (this.fallbackRuntimeId == null) {
                throw new RuntimeException("no fallback minecraft:info_update found.");
            }
        }

        private void register(int runtimeId, BlockEntry entry) {
            this.latestStateHashToEntry.put(entry.latestStateHash, entry);
            this.latestStateHashToCurrent.put(entry.latestStateHash, entry.currentStateHash);
            this.currentStateHashToEntry.put(entry.currentStateHash, entry);
            this.latestStateHashToRuntimeId.put(entry.latestStateHash, runtimeId);
            this.runtimeToLatestStateHash.put(runtimeId, entry.latestStateHash);
        }

        public Integer toRuntimeId(int latestStateHash) {
            return this.latestStateHashToRuntimeId.get(latestStateHash);
        }

        public Integer toLatestStateHash(int runtimeId) {
            return this.runtimeToLatestStateHash.get(runtimeId);
        }

        public Integer toCurrentStateHash(int latestStateHash) {
            return this.latestStateHashToCurrent.get(latestStateHash);
        }

        public BlockEntry toBlockState(int runtimeId) {
            return this.latestStateHashToEntry.get(this.runtimeToLatestStateHash.get(runtimeId));
        }

        public BlockEntry toBlockStateHash(int hashId) {
            return this.currentStateHashToEntry.get(hashId);
        }

        public Integer lookupStateIdFromData(String name, NbtMap state) {
            int stateHash = HashUtils.computeBlockStateHash(name, state);
            if (this.latestStateHashToEntry.containsKey(stateHash)) {
                return stateHash;
            }
            return null;
        }

        public BlockEntry lookupStateFromStateHash(int stateHash) {
            return this.latestStateHashToEntry.get(stateHash);
        }

        private static Dictionary load(int protocolId) {
            Dictionary dictionary;
            block11: {
                InputStream block_state = BlockStateDictionary.open(BlockStateDictionary.lookupAvailableFile("canonical_block_states.nbt", protocolId));
                try {
                    NBTInputStream reader = NbtUtils.createNetworkReader((InputStream)block_state);
                    Int2ObjectRBTreeMap<BlockEntry> list = new Int2ObjectRBTreeMap<BlockEntry>();
                    while (block_state.available() > 0) {
                        Object rawTag = reader.readTag();
                        if (rawTag instanceof NbtList) {
                            NbtList rawList = (NbtList)rawTag;
                            for (Object rawEntry : rawList) {
                                NbtMap entry = (NbtMap)rawEntry;
                                NbtMap rawState = (NbtMap)entry.get((Object)"block");
                                NbtMap state = BlockStateDictionary.hackedUpgradeBlockState(rawState, BlockStateUpdaters.LATEST_VERSION);
                                int latestStateHash = HashUtils.computeBlockStateHash(state);
                                list.put(list.size(), new BlockEntry(rawState.getString("name"), rawState, latestStateHash, HashUtils.computeBlockStateHash(rawState)));
                            }
                            continue;
                        }
                        if (!(rawTag instanceof NbtMap)) continue;
                        NbtMap rawState = (NbtMap)rawTag;
                        NbtMap state = BlockStateDictionary.hackedUpgradeBlockState(rawState, BlockStateUpdaters.LATEST_VERSION);
                        int latestStateHash = HashUtils.computeBlockStateHash(state.getString("name"), state);
                        list.put(list.size(), new BlockEntry(rawState.getString("name"), rawState, latestStateHash, HashUtils.computeBlockStateHash(rawState)));
                    }
                    dictionary = new Dictionary(list);
                    if (block_state == null) break block11;
                }
                catch (Throwable throwable) {
                    if (block_state != null) {
                        try {
                            block_state.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                block_state.close();
            }
            return dictionary;
        }

        @Generated
        public Integer getFallbackRuntimeId() {
            return this.fallbackRuntimeId;
        }

        @Generated
        public List<BlockEntry> getKnownStates() {
            return this.knownStates;
        }

        public record BlockEntry(String name, NbtMap rawState, int latestStateHash, int currentStateHash) {
        }
    }
}

