/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.biome;

import com.github.blackjack200.ouranos.converter.biome.BiomeDefinitionDataBean;
import com.github.blackjack200.ouranos.data.AbstractMapping;
import com.github.blackjack200.ouranos.shaded.gson.Gson;
import com.github.blackjack200.ouranos.shaded.gson.reflect.TypeToken;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.biome.BiomeDefinitionData;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BiomeDefinitionRegistry
extends AbstractMapping {
    private static final BiomeDefinitionRegistry instance = new BiomeDefinitionRegistry();
    private static final Map<Integer, InnerEntry> entries = new ConcurrentHashMap<Integer, InnerEntry>();

    private BiomeDefinitionRegistry() {
    }

    public static InnerEntry getInstance(int protocolId) {
        return entries.computeIfAbsent(protocolId, protocol -> {
            try (InputStream in = BiomeDefinitionRegistry.open(BiomeDefinitionRegistry.lookupAvailableFile("biome_definitions.json", protocol));){
                InnerEntry innerEntry;
                try (InputStreamReader reader = new InputStreamReader(in);){
                    Map rawEntries = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, BiomeDefinitionDataBean>>(){}.getType());
                    HashMap<String, BiomeDefinitionData> entries = new HashMap<String, BiomeDefinitionData>(rawEntries.size());
                    rawEntries.forEach((key, value) -> entries.put((String)key, value.toData()));
                    innerEntry = new InnerEntry(entries);
                }
                return innerEntry;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Generated
    public static BiomeDefinitionRegistry getInstance() {
        return instance;
    }

    public static class InnerEntry {
        private final Map<String, BiomeDefinitionData> stringToDef;
        private final Map<String, BiomeDefinitionData> allEntries;

        private InnerEntry(Map<String, BiomeDefinitionData> entries) {
            this.allEntries = entries;
            this.stringToDef = new ConcurrentHashMap<String, BiomeDefinitionData>();
            this.stringToDef.putAll(this.allEntries);
        }

        public BiomeDefinitionData fromStringId(String itemId) {
            return this.stringToDef.get(itemId);
        }

        public Map<String, BiomeDefinitionData> getEntries() {
            return this.allEntries;
        }
    }
}

