/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.bitarray;

import com.github.blackjack200.ouranos.converter.bitarray.BitArray;
import com.github.blackjack200.ouranos.converter.bitarray.PaddedBitArray;
import com.github.blackjack200.ouranos.converter.bitarray.Pow2BitArray;
import com.github.blackjack200.ouranos.converter.bitarray.SingletonBitArray;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.Preconditions;
import org.cloudburstmc.math.GenericMath;

public enum BitArrayVersion {
    V16(16, 2, null),
    V8(8, 4, V16),
    V6(6, 5, V8),
    V5(5, 6, V6),
    V4(4, 8, V5),
    V3(3, 10, V4),
    V2(2, 16, V3),
    V1(1, 32, V2),
    V0(0, 0, V1);

    private static final BitArrayVersion[] VALUES;
    public final byte bits;
    public final byte entriesPerWord;
    public final int maxEntryIndex;
    public final BitArrayVersion next;

    private BitArrayVersion(int bits, int entriesPerWord, BitArrayVersion next) {
        this.bits = (byte)bits;
        this.entriesPerWord = (byte)entriesPerWord;
        this.maxEntryIndex = (1 << this.bits) - 1;
        this.next = next;
    }

    public static BitArrayVersion getMinimalVersion(int maxEntryIndex) {
        BitArrayVersion version = V0;
        while (version.maxEntryIndex < maxEntryIndex) {
            version = version.next;
        }
        return version;
    }

    public static BitArrayVersion get(int version, boolean read) {
        for (BitArrayVersion ver : VALUES) {
            if ((read || ver.entriesPerWord > version) && (!read || ver.bits != version)) continue;
            return ver;
        }
        if (version == 127 && read) {
            return null;
        }
        throw new IllegalArgumentException("Invalid palette version: " + version);
    }

    public static BitArrayVersion forBitsCeil(int bits) {
        for (int i = VALUES.length - 1; i >= 0; --i) {
            BitArrayVersion version = VALUES[i];
            if (version.bits < bits) continue;
            return version;
        }
        return null;
    }

    public BitArray createArray(int size) {
        if (this == V0) {
            return SingletonBitArray.INSTANCE;
        }
        return this.createArray(size, new int[this.getWordsForSize(size)]);
    }

    public int getWordsForSize(int size) {
        Preconditions.checkArgument(this != V0);
        return GenericMath.ceil((float)((float)size / (float)this.entriesPerWord));
    }

    public BitArray createArray(int size, int[] words) {
        if (this == V0) {
            return SingletonBitArray.INSTANCE;
        }
        if (this == V3 || this == V5 || this == V6) {
            return new PaddedBitArray(this, size, words);
        }
        return new Pow2BitArray(this, size, words);
    }

    static {
        VALUES = BitArrayVersion.values();
    }
}

