/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter.palette;

import com.github.blackjack200.ouranos.converter.bitarray.BitArray;
import com.github.blackjack200.ouranos.converter.bitarray.BitArrayVersion;
import com.github.blackjack200.ouranos.converter.palette.PaletteException;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v465.Bedrock_v465;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class Palette<V> {
    private static final int SECTION_SIZE = 4096;
    private final int blockSize;
    private final List<V> palette;
    private BitArray bitArray;

    private Palette(int blockSize, List<V> palette, BitArray bitArray) {
        this.blockSize = blockSize;
        this.palette = palette;
        this.bitArray = bitArray;
    }

    public Palette(V first) {
        this.blockSize = BitArrayVersion.V2.bits;
        this.bitArray = BitArrayVersion.V2.createArray(4096);
        this.palette = new ArrayList<V>(16);
        this.palette.add(first);
    }

    public V get(int index) {
        return this.palette.get(this.bitArray.get(index));
    }

    private int paletteIndexFor(V value) throws PaletteException {
        int index = this.palette.indexOf(value);
        if (index != -1) {
            return index;
        }
        index = this.palette.size();
        this.palette.add(value);
        BitArrayVersion version = this.bitArray.version();
        if (index > version.maxEntryIndex) {
            BitArrayVersion next = version.next;
            if (next != null) {
                this.onResize(next);
            } else {
                throw new PaletteException("Palette have reached the max bit array version");
            }
        }
        return index;
    }

    private void onResize(BitArrayVersion version) {
        BitArray newBitArray = version.createArray(4096);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.set(i, this.bitArray.get(i));
        }
        this.bitArray = newBitArray;
    }

    public void set(int index, V value) throws PaletteException {
        int paletteIndex = this.paletteIndexFor(value);
        this.bitArray.set(index, paletteIndex);
    }

    public void set(int x, int y, int z, V value) throws PaletteException {
        this.set(Palette.index(x, y, z), value);
    }

    public V get(int x, int y, int z) throws PaletteException {
        return this.get(Palette.index(x, y, z));
    }

    private static int uint32s(int p) {
        int uint32Count = 0;
        if (p != 0) {
            int indicesPerUint32 = 32 / p;
            uint32Count = 4096 / indicesPerUint32;
        }
        if (p == 3 || p == 5 || p == 6) {
            ++uint32Count;
        }
        return uint32Count;
    }

    public void writeNetwork(ByteBuf out, int protocol, Function<V, Integer> serializer) {
        if (this.blockSize == 0) {
            if (protocol >= Bedrock_v465.CODEC.getProtocolVersion()) {
                out.writeByte(1);
            } else {
                out.writeByte(3);
                out.writeBytes(new byte[512]);
                VarInts.writeInt(out, 1);
            }
            VarInts.writeInt(out, serializer.apply(this.palette.get(0)));
            return;
        }
        out.writeByte(this.blockSize << 1 | 1);
        if (this.blockSize == 127) {
            return;
        }
        if (this.bitArray != null) {
            for (int word : this.bitArray.words()) {
                out.writeIntLE(word);
            }
        }
        VarInts.writeInt(out, this.palette.size());
        this.palette.forEach(value -> VarInts.writeInt(out, (Integer)serializer.apply(value)));
    }

    public static <V> Palette<V> readNetwork(ByteBuf in, Function<Integer, V> deserializer) throws PaletteException {
        short header = in.readUnsignedByte();
        if ((header & 1) == 0) {
            throw new PaletteException("Reading persistent data with runtime method!");
        }
        int blockSize = header >> 1;
        if (blockSize == 0) {
            return new Palette<V>(blockSize, List.of(deserializer.apply(VarInts.readInt(in))), BitArrayVersion.V0.createArray(4096, null));
        }
        if (blockSize == 127) {
            return new Palette(blockSize, Collections.emptyList(), null);
        }
        int wordCount = Palette.uint32s(blockSize);
        int[] words = new int[wordCount];
        Arrays.setAll(words, i -> in.readIntLE());
        BitArray bitArray = BitArrayVersion.get(blockSize, true).createArray(4096, words);
        int paletteCount = VarInts.readInt(in);
        if (paletteCount == -1) {
            return new Palette(127, Collections.emptyList(), BitArrayVersion.V0.createArray(4096, null));
        }
        ArrayList<V> palette = new ArrayList<V>(paletteCount);
        for (int i2 = 0; i2 < paletteCount; ++i2) {
            palette.add(deserializer.apply(VarInts.readInt(in)));
        }
        return new Palette(blockSize, palette, bitArray);
    }

    static int index(int x, int y, int z) {
        return (x << 8) + (z << 4) + y;
    }

    @Generated
    public List<V> getPalette() {
        return this.palette;
    }
}

