/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemVersion;
import com.github.blackjack200.ouranos.utils.SimpleVersionedItemDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import org.cloudburstmc.nbt.NBTInputStream;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtUtils;

public record ItemTypeInfo(int runtime_id, boolean component_based, int version, String component_nbt) {
    public ItemVersion getVersion() {
        return ItemVersion.from(this.version);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public NbtMap getComponentNbt() {
        if (this.component_nbt != null) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(Base64.getDecoder().decode(this.component_nbt));){
                NbtMap nbtMap;
                block14: {
                    NBTInputStream reader = NbtUtils.createReaderLE((InputStream)stream);
                    try {
                        nbtMap = (NbtMap)reader.readTag();
                        if (reader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    reader.close();
                }
                return nbtMap;
            }
        }
        return NbtMap.EMPTY;
    }

    public ItemDefinition toDefinition(String id) {
        return new SimpleVersionedItemDefinition(id, this.runtime_id(), this.getVersion(), this.component_based(), this.getComponentNbt());
    }
}

