/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data;

import com.github.blackjack200.ouranos.data.AbstractMapping;
import com.github.blackjack200.ouranos.shaded.fastutil.ints.Int2ObjectArrayMap;
import com.github.blackjack200.ouranos.shaded.fastutil.ints.Int2ObjectRBTreeMap;
import com.github.blackjack200.ouranos.shaded.fastutil.objects.Object2IntRBTreeMap;
import com.github.blackjack200.ouranos.shaded.gson.Gson;
import com.github.blackjack200.ouranos.shaded.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;

public abstract class LegacyToStringBidirectionalIdMap
extends AbstractMapping {
    private final Int2ObjectArrayMap<Map<Integer, String>> intToStringMap = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<Map<String, Integer>> stringToIntMap = new Int2ObjectArrayMap();

    public LegacyToStringBidirectionalIdMap(String file) {
        LegacyToStringBidirectionalIdMap.load(file, (protocolId, rawData) -> {
            try (InputStreamReader reader = new InputStreamReader((InputStream)rawData);){
                Map data = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Integer>>(this){}.getType());
                Object2IntRBTreeMap stringToInt = new Object2IntRBTreeMap();
                Int2ObjectRBTreeMap intToString = new Int2ObjectRBTreeMap();
                data.forEach((stringId, numericId) -> {
                    int primNumId = numericId;
                    stringToInt.put(stringId, primNumId);
                    intToString.put(primNumId, stringId);
                });
                int primProtocolId = protocolId;
                this.intToStringMap.put(primProtocolId, (Map<Integer, String>)intToString);
                this.stringToIntMap.put(primProtocolId, (Map<String, Integer>)stringToInt);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public String fromNumeric(int protocolId, int id) {
        return this.intToStringMap.get(protocolId).get(id);
    }

    public Integer fromString(int protocolId, String id) {
        return this.stringToIntMap.get(protocolId).get(id);
    }

    public Map<String, Integer> getStringToIntMap(int protocolId) {
        return this.stringToIntMap.get(protocolId);
    }
}

