/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data.bedrock.item.downgrade;

import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.data.bedrock.GlobalItemDataHandlers;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgradeSchema;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgrader;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;

public class ItemIdMetaDowngrader {
    private final Map<String, String> renamedIds = new HashMap<String, String>();
    private final Map<String, Object[]> remappedMetas = new HashMap<String, Object[]>();

    public ItemIdMetaDowngrader(ItemTypeDictionary.InnerEntry dictionary, int schemaId) {
        ItemIdMetaUpgrader upgrader = GlobalItemDataHandlers.getUpgrader().idMetaUpgrader();
        HashMap<String, Object> networkIds = new HashMap<String, Object>();
        for (Map.Entry<Integer, ItemIdMetaUpgradeSchema> entry : upgrader.getSchemas().entrySet()) {
            String oldId;
            int id = entry.getKey();
            ItemIdMetaUpgradeSchema schema = entry.getValue();
            if (id <= schemaId) continue;
            for (Map.Entry<String, String> entry2 : schema.renamedIds().entrySet()) {
                oldId = entry2.getKey();
                String newStringId = entry2.getValue();
                if (networkIds.containsKey(oldId)) {
                    networkIds.put(newStringId, networkIds.get(oldId));
                    continue;
                }
                if (dictionary.fromStringId(oldId) == null) continue;
                networkIds.put(newStringId, oldId);
            }
            for (Map.Entry<String, Object> entry3 : schema.remappedMetas().entrySet()) {
                String newStringId;
                String oldMeta;
                oldId = entry3.getKey();
                Map metaToNewId = (Map)entry3.getValue();
                if (networkIds.containsKey(oldId)) {
                    for (Map.Entry metaEntry : metaToNewId.entrySet()) {
                        oldMeta = ((Integer)metaEntry.getKey()).toString();
                        newStringId = (String)metaEntry.getValue();
                        networkIds.put(newStringId, new Object[]{networkIds.get(oldId), oldMeta});
                    }
                    continue;
                }
                if (dictionary.fromStringId(oldId) == null) continue;
                for (Map.Entry metaEntry : metaToNewId.entrySet()) {
                    oldMeta = ((Integer)metaEntry.getKey()).toString();
                    newStringId = (String)metaEntry.getValue();
                    networkIds.put(newStringId, new String[]{oldId, oldMeta});
                }
            }
        }
        for (Map.Entry<Integer, ItemIdMetaUpgradeSchema> entry : networkIds.entrySet()) {
            String newStringId = ((Object)entry.getKey()).toString();
            ItemIdMetaUpgradeSchema oldId = entry.getValue();
            if (oldId instanceof Object[]) {
                this.remappedMetas.put(newStringId, ArrayUtil.cast(String.class, oldId));
                continue;
            }
            this.renamedIds.put(newStringId, (String)((Object)oldId));
        }
    }

    public Object[] downgrade(String id, int meta) {
        String newId = id;
        int newMeta = meta;
        if (this.remappedMetas.containsKey(newId)) {
            Object[] oldData = this.remappedMetas.get(newId);
            newId = (String)oldData[0];
            newMeta = Integer.parseInt((String)oldData[1]);
        } else if (this.renamedIds.containsKey(newId)) {
            newId = this.renamedIds.get(newId);
        }
        return new Object[]{newId, newMeta};
    }
}

