/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.session;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodec;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.utils.BlockDictionaryRegistry;
import io.netty.buffer.ByteBuf;

public abstract class SpecialOuranosSession
extends OuranosSession {
    private final BedrockCodec clientCodec;
    private final BedrockCodecHelper clientCodecHelper;
    private final BedrockCodec serverCodec;
    private final BedrockCodecHelper serverCodecHelper;

    public SpecialOuranosSession(int protocolId, int targetVersion) {
        super(protocolId, targetVersion);
        this.clientCodec = ProtocolInfo.getPacketCodec(protocolId);
        this.serverCodec = ProtocolInfo.getPacketCodec(targetVersion);
        this.clientCodecHelper = this.clientCodec.createHelper();
        this.serverCodecHelper = this.serverCodec.createHelper();
        this.clientCodecHelper.setBlockDefinitions(new BlockDictionaryRegistry(protocolId, false));
        this.serverCodecHelper.setBlockDefinitions(new BlockDictionaryRegistry(targetVersion, false));
    }

    @Override
    public void setHashedBlockIds(boolean hashedBlockIds) {
        this.clientCodecHelper.setBlockDefinitions(new BlockDictionaryRegistry(this.getProtocolId(), hashedBlockIds));
        this.serverCodecHelper.setBlockDefinitions(new BlockDictionaryRegistry(this.getTargetVersion(), hashedBlockIds));
        super.setHashedBlockIds(hashedBlockIds);
    }

    public final Integer translateClientbound(ByteBuf input, ByteBuf output, int id) {
        BedrockPacket packet = this.serverCodec.tryDecode(this.serverCodecHelper, input, id);
        if ((packet = this.translateClientbound(packet)) == null || this.clientCodec.getPacketDefinition(packet.getClass()) == null) {
            return null;
        }
        this.clientCodec.tryEncode(this.clientCodecHelper, output, packet);
        return this.clientCodec.getPacketDefinition(packet.getClass()).getId();
    }

    public final Integer translateServerbound(ByteBuf input, ByteBuf output, int id) {
        BedrockPacket packet = this.clientCodec.tryDecode(this.clientCodecHelper, input, id);
        if ((packet = this.translateServerbound(packet)) == null || this.serverCodec.getPacketDefinition(packet.getClass()) == null) {
            return null;
        }
        this.serverCodec.tryEncode(this.serverCodecHelper, output, packet);
        return this.serverCodec.getPacketDefinition(packet.getClass()).getId();
    }

    public final void encodeClient(BedrockPacket packet, ByteBuf output) {
        this.clientCodec.tryEncode(this.clientCodecHelper, output, packet);
    }

    public final void encodeServer(BedrockPacket packet, ByteBuf output) {
        this.serverCodec.tryEncode(this.serverCodecHelper, output, packet);
    }

    @Generated
    public BedrockCodec getClientCodec() {
        return this.clientCodec;
    }

    @Generated
    public BedrockCodecHelper getClientCodecHelper() {
        return this.clientCodecHelper;
    }

    @Generated
    public BedrockCodec getServerCodec() {
        return this.serverCodec;
    }

    @Generated
    public BedrockCodecHelper getServerCodecHelper() {
        return this.serverCodecHelper;
    }
}

