/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.allymc.updater.block;

import com.github.blackjack200.ouranos.shaded.allymc.updater.block.BlockStateUpdater;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.BlockUpdater;
import com.github.blackjack200.ouranos.shaded.allymc.updater.block.context.BlockUpdaterContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import oxy.geyser.reversion.shaded.jackson.databind.JsonNode;
import oxy.geyser.reversion.shaded.jackson.databind.ObjectMapper;
import oxy.geyser.reversion.shaded.jackson.databind.node.JsonNodeType;

public class BlockStateUpdaterBase
extends BlockStateUpdater {
    public static final BlockStateUpdater INSTANCE = new BlockStateUpdaterBase();
    private static final Map<String, Map<String, Object>[]> LEGACY_BLOCK_DATA_MAP = new HashMap<String, Map<String, Object>[]>();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    private BlockStateUpdaterBase() {
        super(0, 0, 0);
    }

    private static Map<String, Object> convertStateToCompound(JsonNode node) {
        HashMap tag = new HashMap();
        node.fields().forEachRemaining(entry -> {
            String name = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            tag.put(name, switch (value.getNodeType()) {
                case JsonNodeType.BOOLEAN -> value.booleanValue();
                case JsonNodeType.NUMBER -> value.numberValue();
                case JsonNodeType.STRING -> value.textValue();
                default -> throw new UnsupportedOperationException("Unsupported node type: " + String.valueOf((Object)value.getNodeType()) + " for key: " + name);
            });
        });
        return tag.isEmpty() ? Collections.emptyMap() : tag;
    }

    @Override
    public void registerUpdaters(BlockUpdaterContext context) {
        ((BlockUpdater.Builder)((BlockUpdater.Builder)((BlockUpdater.Builder)context.addUpdater()).match("name", "minecraft:.+", true)).match("val", "\\d+", true)).addCompound("states").tryEdit("states", helper -> {
            Map<String, Object> tag = helper.getCompoundTag();
            Map<String, Object> parent = helper.getParent();
            String id = String.valueOf(parent.get("name"));
            int val = Integer.parseInt(String.valueOf(parent.get("val")));
            Map<String, Object>[] statesArray = LEGACY_BLOCK_DATA_MAP.get(id);
            if (statesArray != null) {
                if (val >= statesArray.length) {
                    val = 0;
                }
                tag.putAll(statesArray[val]);
            }
        }).removeProperty("val");
    }

    static {
        try (InputStream stream = Objects.requireNonNull(BlockStateUpdaterBase.class.getClassLoader().getResourceAsStream("legacy_block_data_map.json"), "Resource 'legacy_block_data_map.json' not found");){
            JsonNode node = JSON_MAPPER.readTree(stream);
            node.fields().forEachRemaining(entry -> {
                String name = (String)entry.getKey();
                JsonNode stateNodes = (JsonNode)entry.getValue();
                Map[] states = (Map[])IntStream.range(0, stateNodes.size()).mapToObj(i -> BlockStateUpdaterBase.convertStateToCompound(stateNodes.get(i))).toArray(Map[]::new);
                LEGACY_BLOCK_DATA_MAP.put(name, states);
            });
        }
        catch (IOException e) {
            throw new AssertionError("Error loading legacy block data map", e);
        }
    }
}

