/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.allymc.updater.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.nbt.NbtUtils;

public class TagUtils {
    private static final int FNV1_32_INIT = -2128831035;
    private static final int FNV1_PRIME_32 = 16777619;

    public static Object toMutable(Object immutable) {
        if (immutable instanceof NbtMap) {
            NbtMap map = (NbtMap)immutable;
            LinkedHashMap<String, Object> mutable = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                mutable.put((String)entry.getKey(), TagUtils.toMutable(entry.getValue()));
            }
            return mutable;
        }
        if (immutable instanceof NbtList) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object value : (List)immutable) {
                list.add(TagUtils.toMutable(value));
            }
            return list;
        }
        return immutable;
    }

    public static Object toImmutable(Object mutable) {
        if (mutable instanceof Map) {
            Map map = (Map)mutable;
            NbtMapBuilder immutable = NbtMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                immutable.put((String)entry.getKey(), TagUtils.toImmutable(entry.getValue()));
            }
            return immutable.build();
        }
        if (mutable instanceof List) {
            ArrayList<Object> list = new ArrayList<Object>();
            NbtType type = NbtType.END;
            for (Object value : (List)mutable) {
                if (type == NbtType.END) {
                    type = NbtType.byClass(value.getClass());
                }
                list.add(TagUtils.toImmutable(value));
            }
            return new NbtList(type, list);
        }
        return mutable;
    }

    public static String getTagValue(Object tag) {
        Object object = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class, Boolean.class}, (Object)object, n)) {
            case -1 -> "END";
            case 0 -> {
                Number number = (Number)object;
                yield String.valueOf(number);
            }
            case 1 -> {
                String str;
                yield str = (String)object;
            }
            case 2 -> {
                Boolean bool = (Boolean)object;
                if (bool.booleanValue()) {
                    yield "1";
                }
                yield "0";
            }
            default -> throw new IllegalArgumentException("Invalid tag: " + tag.getClass().getSimpleName());
        };
    }

    public static NbtMap generateVersionFor(NbtMap tag) {
        NbtMap newTag = NbtMap.builder().putString("name", tag.getString("name")).putCompound("states", NbtMap.fromMap(new TreeMap(tag.getCompound("states")))).build();
        return newTag.toBuilder().putInt("version", TagUtils.fnv1a_32_nbt(newTag)).build();
    }

    public static int fnv1a_32_nbt(NbtMap tag) {
        byte[] bytes;
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             NBTOutputStream outputStream = NbtUtils.createWriterLE((OutputStream)stream);){
            outputStream.writeTag((Object)tag);
            bytes = stream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to covert NBT into bytes", e);
        }
        return TagUtils.fnv1a_32(bytes);
    }

    public static int fnv1a_32(byte[] data) {
        int hash = -2128831035;
        for (byte datum : data) {
            hash ^= datum & 0xFF;
            hash *= 16777619;
        }
        return hash;
    }
}

