/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.annotation;

import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AbstractLinkAnnotationPostProcessor;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AbstractWrappedAnnotationAttribute;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AliasedAnnotationAttribute;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AnnotationAttribute;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AnnotationSynthesizer;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.ForceAliasedAnnotationAttribute;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.Link;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.RelationType;
import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.SynthesizedAnnotation;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Opt;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ObjectUtil;
import java.util.function.BinaryOperator;

public class AliasLinkAnnotationPostProcessor
extends AbstractLinkAnnotationPostProcessor {
    private static final RelationType[] PROCESSED_RELATION_TYPES = new RelationType[]{RelationType.ALIAS_FOR, RelationType.FORCE_ALIAS_FOR};

    @Override
    public int order() {
        return -2147483646;
    }

    @Override
    protected RelationType[] processTypes() {
        return PROCESSED_RELATION_TYPES;
    }

    @Override
    protected void processLinkedAttribute(AnnotationSynthesizer synthesizer, Link annotation, SynthesizedAnnotation originalAnnotation, AnnotationAttribute originalAttribute, SynthesizedAnnotation linkedAnnotation, AnnotationAttribute linkedAttribute) {
        this.checkAliasRelation(annotation, originalAttribute, linkedAttribute);
        if (RelationType.ALIAS_FOR.equals((Object)annotation.type())) {
            this.wrappingLinkedAttribute(synthesizer, originalAttribute, linkedAttribute, AliasedAnnotationAttribute::new);
            return;
        }
        this.wrappingLinkedAttribute(synthesizer, originalAttribute, linkedAttribute, ForceAliasedAnnotationAttribute::new);
    }

    private void wrappingLinkedAttribute(AnnotationSynthesizer synthesizer, AnnotationAttribute originalAttribute, AnnotationAttribute aliasAttribute, BinaryOperator<AnnotationAttribute> wrapping) {
        if (!aliasAttribute.isWrapped()) {
            this.processAttribute(synthesizer, originalAttribute, aliasAttribute, wrapping);
            return;
        }
        AbstractWrappedAnnotationAttribute wrapper = (AbstractWrappedAnnotationAttribute)aliasAttribute;
        wrapper.getAllLinkedNonWrappedAttributes().forEach(t -> this.processAttribute(synthesizer, originalAttribute, (AnnotationAttribute)t, wrapping));
    }

    private void processAttribute(AnnotationSynthesizer synthesizer, AnnotationAttribute originalAttribute, AnnotationAttribute target, BinaryOperator<AnnotationAttribute> wrapping) {
        Opt.ofNullable(target.getAnnotationType()).map(synthesizer::getSynthesizedAnnotation).ifPresent(t -> t.replaceAttribute(target.getAttributeName(), old -> (AnnotationAttribute)wrapping.apply((AnnotationAttribute)old, originalAttribute)));
    }

    private void checkAliasRelation(Link annotation, AnnotationAttribute originalAttribute, AnnotationAttribute linkedAttribute) {
        this.checkLinkedAttributeNotNull(originalAttribute, linkedAttribute, annotation);
        this.checkAttributeType(originalAttribute, linkedAttribute);
        this.checkCircularDependency(originalAttribute, linkedAttribute);
    }

    private void checkCircularDependency(AnnotationAttribute original, AnnotationAttribute alias) {
        this.checkLinkedSelf(original, alias);
        Link annotation = this.getLinkAnnotation(alias, RelationType.ALIAS_FOR, RelationType.FORCE_ALIAS_FOR);
        if (ObjectUtil.isNull(annotation)) {
            return;
        }
        Class<?> aliasAnnotationType = this.getLinkedAnnotationType(annotation, alias.getAnnotationType());
        if (ObjectUtil.notEqual(aliasAnnotationType, original.getAnnotationType())) {
            return;
        }
        Assert.notEquals(annotation.attribute(), original.getAttributeName(), "circular reference between the alias attribute [{}] and the original attribute [{}]", alias.getAttribute(), original.getAttribute());
    }
}

