/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.thread;

import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecyclableBatchThreadPoolExecutor {
    private final ExecutorService executor;

    public RecyclableBatchThreadPoolExecutor(int poolSize) {
        this(poolSize, "recyclable-batch-pool-");
    }

    public RecyclableBatchThreadPoolExecutor(int poolSize, String threadPoolPrefix) {
        AtomicInteger threadNumber = new AtomicInteger(1);
        ThreadFactory threadFactory = r -> {
            Thread t = new Thread(r, threadPoolPrefix + threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        };
        this.executor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public RecyclableBatchThreadPoolExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public <T, R> List<R> process(List<T> data, int batchSize, Function<T, R> processor) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize >= 1");
        }
        List batches = RecyclableBatchThreadPoolExecutor.splitData(data, batchSize);
        int batchCount = batches.size();
        int minusOne = batchCount - 1;
        ArrayDeque<IdempotentTask<R>> taskQueue = new ArrayDeque<IdempotentTask<R>>(minusOne);
        HashMap<Integer, Future<TaskResult<R>>> futuresMap = new HashMap<Integer, Future<TaskResult<R>>>();
        for (int i = 0; i < minusOne; ++i) {
            int index = i;
            IdempotentTask task = new IdempotentTask(i, () -> RecyclableBatchThreadPoolExecutor.processBatch((List)batches.get(index), processor));
            taskQueue.add(task);
            futuresMap.put(i, this.executor.submit(task));
        }
        ArrayList[] resultArr = new ArrayList[batchCount];
        resultArr[minusOne] = RecyclableBatchThreadPoolExecutor.processBatch(batches.get(minusOne), processor);
        this.processRemainingTasks(taskQueue, futuresMap, resultArr);
        return Stream.of(resultArr).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private <R> void processRemainingTasks(Queue<IdempotentTask<R>> taskQueue, Map<Integer, Future<TaskResult<R>>> futuresMap, List<R>[] resultArr) {
        IdempotentTask<R> task;
        while ((task = taskQueue.poll()) != null) {
            try {
                Object call = task.call();
                if (!((TaskResult)call).effective) continue;
                Future<TaskResult<R>> future2 = futuresMap.remove(((IdempotentTask)task).index);
                future2.cancel(false);
                resultArr[((IdempotentTask)task).index] = ((TaskResult)call).result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        futuresMap.forEach((index, future) -> {
            try {
                TaskResult taskResult = (TaskResult)future.get();
                if (taskResult.effective) {
                    resultArr[index.intValue()] = taskResult.result;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> List<List<T>> splitData(final List<T> data, final int batchSize) {
        final int batchCount = (data.size() + batchSize - 1) / batchSize;
        return new AbstractList<List<T>>(){

            @Override
            public List<T> get(int index) {
                int from = index * batchSize;
                int to = Math.min((index + 1) * batchSize, data.size());
                return data.subList(from, to);
            }

            @Override
            public int size() {
                return batchCount;
            }
        };
    }

    private static <T, R> List<R> processBatch(List<T> batch, Function<T, R> processor) {
        return batch.stream().map(processor).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Warp<?>> processByWarp(Warp<?> ... warps) {
        return this.processByWarp(Arrays.asList(warps));
    }

    public List<Warp<?>> processByWarp(List<Warp<?>> warps) {
        return this.process(warps, 1, Warp::execute);
    }

    public static class Warp<R> {
        private final Supplier<R> supplier;
        private R result;

        private Warp(Supplier<R> supplier) {
            Objects.requireNonNull(supplier);
            this.supplier = supplier;
        }

        public static <R> Warp<R> of(Supplier<R> supplier) {
            return new Warp<R>(supplier);
        }

        public R get() {
            return this.result;
        }

        public Warp<R> execute() {
            this.result = this.supplier.get();
            return this;
        }
    }

    private static class TaskResult<R> {
        private final List<R> result;
        private final boolean effective;

        TaskResult(List<R> result, boolean effective) {
            this.result = result;
            this.effective = effective;
        }
    }

    private static class IdempotentTask<R>
    implements Callable<TaskResult<R>> {
        private final int index;
        private final Callable<List<R>> delegate;
        private final AtomicBoolean executed = new AtomicBoolean(false);

        IdempotentTask(int index, Callable<List<R>> delegate) {
            this.index = index;
            this.delegate = delegate;
        }

        @Override
        public TaskResult<R> call() throws Exception {
            if (this.executed.compareAndSet(false, true)) {
                return new TaskResult<R>(this.delegate.call(), true);
            }
            return new TaskResult(null, false);
        }
    }
}

