/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v554.serializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v388.serializer.NetworkSettingsSerializer_v388;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PacketCompressionAlgorithm;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.NetworkSettingsPacket;
import io.netty.buffer.ByteBuf;

public class NetworkSettingsSerializer_v554
extends NetworkSettingsSerializer_v388 {
    protected static final PacketCompressionAlgorithm[] ALGORITHMS = PacketCompressionAlgorithm.values();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, NetworkSettingsPacket packet) {
        super.serialize(buffer, helper, packet);
        buffer.writeShortLE(packet.getCompressionAlgorithm().ordinal());
        buffer.writeBoolean(packet.isClientThrottleEnabled());
        buffer.writeByte(packet.getClientThrottleThreshold());
        buffer.writeFloatLE(packet.getClientThrottleScalar());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, NetworkSettingsPacket packet) {
        super.deserialize(buffer, helper, packet);
        packet.setCompressionAlgorithm(ALGORITHMS[buffer.readUnsignedShortLE()]);
        packet.setClientThrottleEnabled(buffer.readBoolean());
        packet.setClientThrottleThreshold(buffer.readUnsignedByte());
        packet.setClientThrottleScalar(buffer.readFloatLE());
    }
}

