/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v557;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v554.BedrockCodecHelper_v554;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.Ability;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityProperties;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.FloatEntityProperty;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.IntEntityProperty;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.descriptor.ItemDescriptorWithCount;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.TextProcessingEventOrigin;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.AutoCraftRecipeAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class BedrockCodecHelper_v557
extends BedrockCodecHelper_v554 {
    public BedrockCodecHelper_v557(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes, TypeMap<Ability> abilities, TypeMap<TextProcessingEventOrigin> textProcessingEventOrigins) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes, abilities, textProcessingEventOrigins);
    }

    @Override
    public void readEntityProperties(ByteBuf buffer, EntityProperties properties) {
        this.readArray(buffer, properties.getIntProperties(), (ByteBuf byteBuf) -> {
            int index = VarInts.readUnsignedInt(byteBuf);
            int value = VarInts.readInt(byteBuf);
            return new IntEntityProperty(index, value);
        });
        this.readArray(buffer, properties.getFloatProperties(), (ByteBuf byteBuf) -> {
            int index = VarInts.readUnsignedInt(byteBuf);
            float value = byteBuf.readFloatLE();
            return new FloatEntityProperty(index, value);
        });
    }

    @Override
    public void writeEntityProperties(ByteBuf buffer, EntityProperties properties) {
        this.writeArray(buffer, properties.getIntProperties(), (ByteBuf byteBuf, T property) -> {
            VarInts.writeUnsignedInt(byteBuf, property.getIndex());
            VarInts.writeInt(byteBuf, property.getValue());
        });
        this.writeArray(buffer, properties.getFloatProperties(), (ByteBuf byteBuf, T property) -> {
            VarInts.writeUnsignedInt(byteBuf, property.getIndex());
            byteBuf.writeFloatLE(property.getValue());
        });
    }

    @Override
    protected ItemStackRequestAction readRequestActionData(ByteBuf byteBuf, ItemStackRequestActionType type) {
        if (type == ItemStackRequestActionType.CRAFT_RECIPE_AUTO) {
            int recipeId = VarInts.readUnsignedInt(byteBuf);
            short timesCrafted = byteBuf.readUnsignedByte();
            ObjectArrayList<ItemDescriptorWithCount> ingredients = new ObjectArrayList<ItemDescriptorWithCount>();
            this.readArray(byteBuf, ingredients, ByteBuf::readUnsignedByte, (ByteBuf buf, BedrockCodecHelper helper) -> helper.readIngredient((ByteBuf)buf));
            return new AutoCraftRecipeAction(recipeId, timesCrafted, ingredients, 0);
        }
        return super.readRequestActionData(byteBuf, type);
    }

    @Override
    protected void writeRequestActionData(ByteBuf byteBuf, ItemStackRequestAction action) {
        super.writeRequestActionData(byteBuf, action);
        if (action.getType() == ItemStackRequestActionType.CRAFT_RECIPE_AUTO) {
            List<ItemDescriptorWithCount> ingredients = ((AutoCraftRecipeAction)action).getIngredients();
            byteBuf.writeByte(ingredients.size());
            this.writeArray(byteBuf, ingredients, this::writeIngredient);
        }
    }
}

