/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.batch;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.BedrockBatchWrapper;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

@ChannelHandler.Sharable
public class BedrockBatchDecoder
extends MessageToMessageDecoder<BedrockBatchWrapper> {
    public static final String NAME = "bedrock-batch-decoder";

    protected void decode(ChannelHandlerContext ctx, BedrockBatchWrapper msg, List<Object> out) {
        if (msg.getUncompressed() == null) {
            throw new IllegalStateException("Batch packet was not decompressed");
        }
        ByteBuf buffer = msg.getUncompressed().slice();
        while (buffer.isReadable()) {
            int packetLength = VarInts.readUnsignedInt(buffer);
            ByteBuf packetBuf = buffer.readRetainedSlice(packetLength);
            out.add(packetBuf);
        }
    }
}

