/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.initializer;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.BedrockPeer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.BedrockSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.CompressionAlgorithm;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PacketCompressionAlgorithm;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.FrameIdCodec;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.batch.BedrockBatchDecoder;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.batch.BedrockBatchEncoder;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.CompressionCodec;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.CompressionStrategy;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.NoopCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.SimpleCompressionStrategy;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.SnappyCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.compression.ZlibCompression;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v1;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v2;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.packet.BedrockPacketCodec_v3;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.Zlib;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;

public abstract class BedrockChannelInitializer<T extends BedrockSession>
extends ChannelInitializer<Channel> {
    public static final int RAKNET_MINECRAFT_ID = 254;
    private static final FrameIdCodec RAKNET_FRAME_CODEC = new FrameIdCodec(254);
    private static final BedrockBatchDecoder BATCH_DECODER = new BedrockBatchDecoder();
    private static final CompressionStrategy ZLIB_RAW_STRATEGY = new SimpleCompressionStrategy(new ZlibCompression(Zlib.RAW));
    private static final CompressionStrategy ZLIB_STRATEGY = new SimpleCompressionStrategy(new ZlibCompression(Zlib.DEFAULT));
    private static final CompressionStrategy SNAPPY_STRATEGY = new SimpleCompressionStrategy(new SnappyCompression());
    private static final CompressionStrategy NOOP_STRATEGY = new SimpleCompressionStrategy(new NoopCompression());

    protected final void initChannel(Channel channel) throws Exception {
        this.preInitChannel(channel);
        channel.pipeline().addLast("bedrock-batch-decoder", (ChannelHandler)BATCH_DECODER).addLast("bedrock-batch-encoder", (ChannelHandler)new BedrockBatchEncoder());
        this.initPacketCodec(channel);
        channel.pipeline().addLast("bedrock-peer", (ChannelHandler)this.createPeer(channel));
        this.postInitChannel(channel);
    }

    protected void preInitChannel(Channel channel) throws Exception {
        channel.pipeline().addLast("frame-id-codec", (ChannelHandler)RAKNET_FRAME_CODEC);
        int rakVersion = (Integer)channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        CompressionStrategy compression = BedrockChannelInitializer.getCompression(PacketCompressionAlgorithm.ZLIB, rakVersion, true);
        channel.pipeline().addLast("compression-codec", (ChannelHandler)new CompressionCodec(compression, false));
    }

    public static CompressionStrategy getCompression(CompressionAlgorithm algorithm, int rakVersion, boolean initial) {
        switch (rakVersion) {
            case 7: 
            case 8: 
            case 9: {
                return ZLIB_STRATEGY;
            }
            case 10: {
                return ZLIB_RAW_STRATEGY;
            }
            case 11: {
                return initial ? NOOP_STRATEGY : BedrockChannelInitializer.getCompression(algorithm);
            }
        }
        throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
    }

    private static CompressionStrategy getCompression(CompressionAlgorithm algorithm) {
        if (algorithm == PacketCompressionAlgorithm.ZLIB) {
            return ZLIB_RAW_STRATEGY;
        }
        if (algorithm == PacketCompressionAlgorithm.SNAPPY) {
            return SNAPPY_STRATEGY;
        }
        if (algorithm == PacketCompressionAlgorithm.NONE) {
            return NOOP_STRATEGY;
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + algorithm);
    }

    protected void postInitChannel(Channel channel) throws Exception {
    }

    protected void initPacketCodec(Channel channel) throws Exception {
        int rakVersion = (Integer)channel.config().getOption(RakChannelOption.RAK_PROTOCOL_VERSION);
        switch (rakVersion) {
            case 9: 
            case 10: 
            case 11: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v3());
                break;
            }
            case 8: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v2());
                break;
            }
            case 7: {
                channel.pipeline().addLast("bedrock-packet-codec", (ChannelHandler)new BedrockPacketCodec_v1());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported RakNet protocol version: " + rakVersion);
            }
        }
    }

    protected BedrockPeer createPeer(Channel channel) {
        return new BedrockPeer(channel, this::createSession);
    }

    protected final T createSession(BedrockPeer peer, int subClientId) {
        T session = this.createSession0(peer, subClientId);
        this.initSession(session);
        return session;
    }

    protected abstract T createSession0(BedrockPeer var1, int var2);

    protected abstract void initSession(T var1);
}

