/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.CameraShakeAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.CameraShakeType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacketHandler;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacketType;
import com.github.blackjack200.ouranos.shaded.protocol.common.PacketSignal;

public class CameraShakePacket
implements BedrockPacket {
    private float intensity;
    private float duration;
    private CameraShakeType shakeType;
    private CameraShakeAction shakeAction;

    @Override
    public PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.CAMERA_SHAKE;
    }

    @Override
    public CameraShakePacket clone() {
        try {
            return (CameraShakePacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getDuration() {
        return this.duration;
    }

    public CameraShakeType getShakeType() {
        return this.shakeType;
    }

    public CameraShakeAction getShakeAction() {
        return this.shakeAction;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setShakeType(CameraShakeType shakeType) {
        this.shakeType = shakeType;
    }

    public void setShakeAction(CameraShakeAction shakeAction) {
        this.shakeAction = shakeAction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraShakePacket)) {
            return false;
        }
        CameraShakePacket other = (CameraShakePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.intensity, other.intensity) != 0) {
            return false;
        }
        if (Float.compare(this.duration, other.duration) != 0) {
            return false;
        }
        CameraShakeType this$shakeType = this.shakeType;
        CameraShakeType other$shakeType = other.shakeType;
        if (this$shakeType == null ? other$shakeType != null : !((Object)((Object)this$shakeType)).equals((Object)other$shakeType)) {
            return false;
        }
        CameraShakeAction this$shakeAction = this.shakeAction;
        CameraShakeAction other$shakeAction = other.shakeAction;
        return !(this$shakeAction == null ? other$shakeAction != null : !((Object)((Object)this$shakeAction)).equals((Object)other$shakeAction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraShakePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.intensity);
        result = result * 59 + Float.floatToIntBits(this.duration);
        CameraShakeType $shakeType = this.shakeType;
        result = result * 59 + ($shakeType == null ? 43 : ((Object)((Object)$shakeType)).hashCode());
        CameraShakeAction $shakeAction = this.shakeAction;
        result = result * 59 + ($shakeAction == null ? 43 : ((Object)((Object)$shakeAction)).hashCode());
        return result;
    }

    public String toString() {
        return "CameraShakePacket(intensity=" + this.intensity + ", duration=" + this.duration + ", shakeType=" + (Object)((Object)this.shakeType) + ", shakeAction=" + (Object)((Object)this.shakeAction) + ")";
    }
}

