/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.converter.ChunkRewriteException;
import com.github.blackjack200.ouranos.converter.TypeConverter;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v475.Bedrock_v475;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.BlockChangeEntry;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.LevelEvent;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.LevelEventType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.ParticleType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.SoundEvent;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.SubChunkData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityDataMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityDataTypes;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.entity.EntityEventType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.AddEntityPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.EntityEventPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.LevelChunkPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.LevelEventPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.LevelSoundEventPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.SubChunkPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.UpdateBlockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.UpdateSubChunkBlocksPacket;
import com.github.blackjack200.ouranos.utils.SimpleBlockDefinition;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;

public class GlobalWorldTranslator
extends ProtocolToProtocol {
    private static final List<LevelEventType> BLOCK_BREAK_PARTICLE_EVENTS = List.of(LevelEvent.PARTICLE_BREAK_BLOCK_DOWN, LevelEvent.PARTICLE_BREAK_BLOCK_UP, LevelEvent.PARTICLE_BREAK_BLOCK_NORTH, LevelEvent.PARTICLE_BREAK_BLOCK_SOUTH, LevelEvent.PARTICLE_BREAK_BLOCK_WEST, LevelEvent.PARTICLE_BREAK_BLOCK_EAST, LevelEvent.PARTICLE_DESTROY_BLOCK);

    @Override
    protected void registerProtocol() {
        this.registerClientbound(UpdateBlockPacket.class, wrapped -> {
            UpdateBlockPacket packet = (UpdateBlockPacket)wrapped.getPacket();
            packet.setDefinition(new SimpleBlockDefinition(TypeConverter.translateBlockRuntimeId(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), packet.getDefinition().getRuntimeId())));
        });
        this.registerClientbound(LevelEventPacket.class, wrapped -> {
            LevelEventPacket packet = (LevelEventPacket)wrapped.getPacket();
            int input = wrapped.getInput();
            int output = wrapped.getOutput();
            LevelEventType type = packet.getType();
            int data = packet.getData();
            if (type == ParticleType.ICON_CRACK) {
                int[] newItem = TypeConverter.translateItemRuntimeId(wrapped.session().isHashedBlockIds(), input, output, data >> 16, data & 0xFFFF);
                data = newItem[0] << 16 | newItem[1];
            } else if (BLOCK_BREAK_PARTICLE_EVENTS.contains(type)) {
                data = TypeConverter.translateBlockRuntimeId(wrapped.session().isHashedBlockIds(), input, output, data);
            } else if (type == LevelEvent.PARTICLE_CRACK_BLOCK) {
                int face = data >> 24;
                int runtimeId = data & ~(face << 24);
                data = TypeConverter.translateBlockRuntimeId(wrapped.session().isHashedBlockIds(), input, output, runtimeId) | face << 24;
            }
            packet.setData(data);
        });
        this.registerClientbound(LevelSoundEventPacket.class, wrapped -> {
            LevelSoundEventPacket packet = (LevelSoundEventPacket)wrapped.getPacket();
            SoundEvent sound = packet.getSound();
            if (sound == SoundEvent.PLACE || sound == SoundEvent.BREAK_BLOCK || sound == SoundEvent.ITEM_USE_ON) {
                packet.setExtraData(TypeConverter.translateBlockRuntimeId(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), packet.getExtraData()));
            }
        });
        this.registerClientbound(EntityEventPacket.class, wrapped -> {
            EntityEventPacket packet = (EntityEventPacket)wrapped.getPacket();
            if (packet.getType() == EntityEventType.EATING_ITEM) {
                int data = packet.getData();
                int[] newItem = TypeConverter.translateItemRuntimeId(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), data >> 16, data & 0xFFFF);
                packet.setData(newItem[0] << 16 | newItem[1]);
            }
        });
        this.registerClientbound(AddEntityPacket.class, wrapped -> {
            AddEntityPacket packet = (AddEntityPacket)wrapped.getPacket();
            if (!packet.getIdentifier().equals("minecraft:falling_block") || packet.getMetadata() == null) {
                return;
            }
            EntityDataMap data = packet.getMetadata();
            Integer runtimeId = data.get(EntityDataTypes.VARIANT);
            if (runtimeId != null) {
                data.put(EntityDataTypes.VARIANT, (Object)TypeConverter.translateBlockRuntimeId(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), runtimeId));
            }
        });
        this.registerClientbound(UpdateSubChunkBlocksPacket.class, wrapped -> {
            UpdateSubChunkBlocksPacket packet = (UpdateSubChunkBlocksPacket)wrapped.getPacket();
            ArrayList<BlockChangeEntry> newExtraBlocks = new ArrayList<BlockChangeEntry>(packet.getExtraBlocks().size());
            for (BlockChangeEntry entry : packet.getExtraBlocks()) {
                newExtraBlocks.add(new BlockChangeEntry(entry.getPosition(), TypeConverter.translateBlockDefinition(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), entry.getDefinition()), entry.getUpdateFlags(), entry.getMessageEntityId(), entry.getMessageType()));
            }
            packet.getExtraBlocks().clear();
            packet.getExtraBlocks().addAll(newExtraBlocks);
            ArrayList<BlockChangeEntry> newStandardBlock = new ArrayList<BlockChangeEntry>(packet.getStandardBlocks().size());
            for (BlockChangeEntry entry : packet.getStandardBlocks()) {
                newStandardBlock.add(new BlockChangeEntry(entry.getPosition(), TypeConverter.translateBlockDefinition(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), entry.getDefinition()), entry.getUpdateFlags(), entry.getMessageEntityId(), entry.getMessageType()));
            }
            packet.getStandardBlocks().clear();
            packet.getStandardBlocks().addAll(newStandardBlock);
        });
        this.registerClientbound(LevelChunkPacket.class, wrapped -> {
            LevelChunkPacket packet = (LevelChunkPacket)wrapped.getPacket();
            ByteBuf from = packet.getData();
            ByteBuf to = AbstractByteBufAllocator.DEFAULT.buffer(from.readableBytes()).touch();
            try {
                int newSubChunkCount = TypeConverter.rewriteFullChunk(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), from, to, packet.getDimension(), packet.getSubChunksLength());
                packet.setSubChunksLength(newSubChunkCount);
                packet.setData(to.retain());
            }
            catch (ChunkRewriteException chunkRewriteException) {
            }
            finally {
                ReferenceCountUtil.release((Object)from);
                ReferenceCountUtil.release((Object)to);
            }
        });
        this.registerClientbound(SubChunkPacket.class, wrapped -> {
            SubChunkPacket packet = (SubChunkPacket)wrapped.getPacket();
            for (SubChunkData subChunk : packet.getSubChunks()) {
                if (subChunk.getData().readableBytes() <= 0) continue;
                ByteBuf from = subChunk.getData();
                ByteBuf to = AbstractByteBufAllocator.DEFAULT.buffer(from.readableBytes());
                try {
                    TypeConverter.rewriteSubChunk(wrapped.session().isHashedBlockIds(), wrapped.getInput(), wrapped.getOutput(), from, to);
                    TypeConverter.rewriteBlockEntities(wrapped.getInput(), wrapped.getOutput(), from, to);
                    to.writeBytes(from);
                    subChunk.setData(to.retain());
                }
                catch (ChunkRewriteException chunkRewriteException) {}
                continue;
                finally {
                    ReferenceCountUtil.release((Object)from);
                    ReferenceCountUtil.release((Object)to);
                }
            }
            if (wrapped.getOutput() < Bedrock_v475.CODEC.getProtocolVersion()) {
                packet.getSubChunks().subList(0, 4).clear();
            }
        });
    }
}

