/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators.new_to_old.v407to390;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.CreativeItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.FullContainerName;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemVersion;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.PlaceAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.TakeAction;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseContainer;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseSlot;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.transaction.InventoryActionData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.transaction.InventorySource;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.CreativeContentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventoryContentPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventorySlotPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.InventoryTransactionPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackRequestPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackResponsePacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.MobEquipmentPacket;
import com.github.blackjack200.ouranos.translators.new_to_old.v407to390.storage.ClientAuthInventoryStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Protocol407to390
extends ProtocolToProtocol {
    @Override
    public void init(OuranosSession session) {
        session.put(new ClientAuthInventoryStorage(session));
    }

    @Override
    protected void registerProtocol() {
        this.registerClientbound(CreativeContentPacket.class, wrapped -> {
            CreativeContentPacket packet = (CreativeContentPacket)wrapped.getPacket();
            InventoryContentPacket newPacket = new InventoryContentPacket();
            newPacket.setContainerId(121);
            newPacket.setContents(packet.getContents().stream().map(CreativeItemData::getItem).filter(i -> i.getDefinition().getVersion().equals((Object)ItemVersion.LEGACY)).collect(Collectors.toList()));
            wrapped.setPacket(newPacket);
        });
        this.registerClientbound(InventoryContentPacket.class, wrapped -> {
            InventoryContentPacket packet = (InventoryContentPacket)wrapped.getPacket();
            if (wrapped.session().isServerAuthoritativeInventories()) {
                wrapped.session().get(ClientAuthInventoryStorage.class).getInventories().put(packet.getContainerId(), new ArrayList<ItemData>(packet.getContents()));
            }
        });
        this.registerClientbound(InventorySlotPacket.class, wrapped -> {
            InventorySlotPacket packet = (InventorySlotPacket)wrapped.getPacket();
            OuranosSession session = wrapped.session();
            ClientAuthInventoryStorage storage = session.get(ClientAuthInventoryStorage.class);
            if (session.isServerAuthoritativeInventories()) {
                storage.getInventories().putIfAbsent(packet.getContainerId(), new ArrayList());
                List<ItemData> inv = storage.getInventories().get(packet.getContainerId());
                while (inv.size() <= packet.getSlot()) {
                    inv.add(ItemData.AIR);
                }
                inv.set(packet.getSlot(), packet.getItem());
            }
        });
        this.registerClientbound(MobEquipmentPacket.class, wrapped -> {
            MobEquipmentPacket packet = (MobEquipmentPacket)wrapped.getPacket();
            OuranosSession session = wrapped.session();
            ClientAuthInventoryStorage storage = session.get(ClientAuthInventoryStorage.class);
            if (session.isServerAuthoritativeInventories()) {
                storage.getInventories().putIfAbsent(packet.getContainerId(), new ArrayList());
                List<ItemData> inv = storage.getInventories().get(packet.getContainerId());
                while (inv.size() < packet.getInventorySlot()) {
                    inv.add(ItemData.AIR);
                }
                inv.set(packet.getInventorySlot(), packet.getItem());
            }
        });
        this.registerClientbound(ItemStackResponsePacket.class, wrapped -> {
            ItemStackResponsePacket packet = (ItemStackResponsePacket)wrapped.getPacket();
            OuranosSession session = wrapped.session();
            ClientAuthInventoryStorage storage = session.get(ClientAuthInventoryStorage.class);
            if (!session.isServerAuthoritativeInventories()) {
                return;
            }
            for (ItemStackResponse entry : packet.getEntries()) {
                Consumer<List<ItemStackResponseContainer>> xa = storage.getStackResponses().get(entry.getRequestId());
                storage.getStackResponses().remove(entry.getRequestId());
                if (entry.getResult() == ItemStackResponseStatus.OK) {
                    if (xa != null) {
                        xa.accept(entry.getContainers());
                    }
                    for (ItemStackResponseContainer slot : entry.getContainers()) {
                        int id = Protocol407to390.parseContainerId(slot.getContainerName().getContainer());
                        List<ItemData> container = storage.getInventories().get(id);
                        if (container == null) continue;
                        for (ItemStackResponseSlot item : slot.getItems()) {
                            container.set(item.getSlot(), container.get(item.getSlot()).toBuilder().count(item.getCount()).damage(item.getDurabilityCorrection()).usingNetId(true).netId(item.getStackNetworkId()).build());
                        }
                    }
                    continue;
                }
                storage.getInventories().forEach((containerId, contents) -> {
                    InventoryContentPacket pp = new InventoryContentPacket();
                    pp.setContainerId((int)containerId);
                    pp.setContents((List<ItemData>)contents);
                    session.sendUpstreamPacket(pp);
                });
                wrapped.cancel();
            }
        });
        this.registerServerbound(InventoryTransactionPacket.class, wrapped -> {
            ClientAuthInventoryStorage storage = wrapped.session().get(ClientAuthInventoryStorage.class);
            InventoryTransactionPacket packet = (InventoryTransactionPacket)wrapped.getPacket();
            if (packet.getActions().size() != 2) {
                return;
            }
            InventoryActionData a = packet.getActions().get(0);
            InventoryActionData b = packet.getActions().get(1);
            ItemStackRequestPacket stackPacket = new ItemStackRequestPacket();
            ContainerSlotType slotType = Protocol407to390.parseContainerId(a.getSource().getContainerId());
            ContainerSlotType otherSlotType = Protocol407to390.parseContainerId(b.getSource().getContainerId());
            if (a.getSource().getType() == InventorySource.Type.CONTAINER && b.getSource().getType() == InventorySource.Type.CONTAINER) {
                return;
            }
            ItemData source = storage.getInventories().get(a.getSource().getContainerId()).get(a.getSlot());
            ItemData destination = storage.getInventories().get(b.getSource().getContainerId()).get(b.getSlot());
            if (!source.isNull()) {
                int count = Math.abs(source.getCount() - a.getToItem().getCount());
                if (destination.isNull()) {
                    stackPacket.getRequests().add(new ItemStackRequest(0, new ItemStackRequestAction[]{new TakeAction(count, new ItemStackRequestSlotData(slotType, a.getSlot(), source.getNetId(), new FullContainerName(slotType, 0)), new ItemStackRequestSlotData(otherSlotType, b.getSlot(), destination.getNetId(), new FullContainerName(otherSlotType, 0)))}, new String[0]));
                    storage.getStackResponses().put(0, slots -> {
                        storage.getInventories().get(a.getSource().getContainerId()).set(a.getSlot(), source.toBuilder().count(source.getCount() - count).build());
                        storage.getInventories().get(b.getSource().getContainerId()).set(b.getSlot(), source.toBuilder().count(count).build());
                    });
                } else {
                    stackPacket.getRequests().add(new ItemStackRequest(1, new ItemStackRequestAction[]{new PlaceAction(count, new ItemStackRequestSlotData(slotType, a.getSlot(), source.getNetId(), new FullContainerName(slotType, 0)), new ItemStackRequestSlotData(otherSlotType, b.getSlot(), destination.getNetId(), new FullContainerName(otherSlotType, 0)))}, new String[0]));
                    storage.getStackResponses().put(1, slots -> {
                        storage.getInventories().get(a.getSource().getContainerId()).set(a.getSlot(), source.toBuilder().count(source.getCount() - count).build());
                        storage.getInventories().get(b.getSource().getContainerId()).set(b.getSlot(), destination.toBuilder().count(destination.getCount() + count).build());
                    });
                }
            } else {
                stackPacket.getRequests().add(new ItemStackRequest(2, new ItemStackRequestAction[]{new SwapAction(new ItemStackRequestSlotData(slotType, a.getSlot(), source.getNetId(), new FullContainerName(slotType, 0)), new ItemStackRequestSlotData(otherSlotType, b.getSlot(), destination.getNetId(), new FullContainerName(otherSlotType, 0)))}, new String[0]));
                storage.getStackResponses().put(2, slots -> {
                    storage.getInventories().get(a.getSource().getContainerId()).set(a.getSlot(), destination);
                    storage.getInventories().get(b.getSource().getContainerId()).set(b.getSlot(), source);
                });
            }
            wrapped.setPacket(stackPacket);
        });
    }

    private static ContainerSlotType parseContainerId(int containerId) {
        return switch (containerId) {
            case 0 -> ContainerSlotType.INVENTORY;
            case 122 -> ContainerSlotType.HOTBAR;
            case 120 -> ContainerSlotType.ARMOR;
            case 119 -> ContainerSlotType.OFFHAND;
            case 124 -> ContainerSlotType.CURSOR;
            case -24 -> ContainerSlotType.BEACON_PAYMENT;
            case -15 -> ContainerSlotType.ENCHANTING_INPUT;
            case -17 -> ContainerSlotType.ENCHANTING_MATERIAL;
            default -> ContainerSlotType.UNKNOWN;
        };
    }

    private static int parseContainerId(ContainerSlotType containerId) {
        return switch (containerId) {
            case ContainerSlotType.UNKNOWN -> -1;
            case ContainerSlotType.INVENTORY, ContainerSlotType.HOTBAR, ContainerSlotType.HOTBAR_AND_INVENTORY -> 0;
            case ContainerSlotType.ARMOR -> 120;
            case ContainerSlotType.OFFHAND -> 119;
            case ContainerSlotType.CURSOR -> 124;
            case ContainerSlotType.BEACON_PAYMENT -> -24;
            case ContainerSlotType.ENCHANTING_INPUT -> -15;
            case ContainerSlotType.ENCHANTING_MATERIAL -> -17;
            default -> ContainerSlotType.UNKNOWN.ordinal();
        };
    }
}

