/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators.new_to_old.v428to422;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.session.OuranosSession;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.AuthoritativeMovementMode;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PlayerActionType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PlayerAuthInputData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PlayerBlockActionData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerActionPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerAuthInputPacket;
import com.github.blackjack200.ouranos.translators.new_to_old.v428to422.storage.BlockBreakingStorage;

public class Protocol428to422
extends ProtocolToProtocol {
    @Override
    public void init(OuranosSession session) {
        session.put(new BlockBreakingStorage(session));
    }

    @Override
    protected void registerProtocol() {
        this.registerServerbound(PlayerActionPacket.class, wrapped -> {
            if (wrapped.session().getAuthoritativeMovementMode() == AuthoritativeMovementMode.CLIENT) {
                return;
            }
            boolean serverAuth = wrapped.session().isServerAuthoritativeBlockBreaking();
            BlockBreakingStorage storage = wrapped.session().get(BlockBreakingStorage.class);
            PlayerActionPacket packet = (PlayerActionPacket)wrapped.getPacket();
            PlayerActionType actionType = packet.getAction();
            switch (actionType) {
                case START_BREAK: 
                case STOP_BREAK: 
                case ABORT_BREAK: 
                case CONTINUE_BREAK: {
                    PlayerBlockActionData data = new PlayerBlockActionData();
                    data.setAction(switch (actionType) {
                        case PlayerActionType.START_BREAK -> PlayerActionType.START_BREAK;
                        case PlayerActionType.STOP_BREAK -> {
                            if (serverAuth) {
                                yield PlayerActionType.BLOCK_PREDICT_DESTROY;
                            }
                            yield PlayerActionType.STOP_BREAK;
                        }
                        case PlayerActionType.ABORT_BREAK -> PlayerActionType.ABORT_BREAK;
                        case PlayerActionType.CONTINUE_BREAK -> {
                            if (serverAuth) {
                                yield PlayerActionType.BLOCK_CONTINUE_DESTROY;
                            }
                            yield PlayerActionType.CONTINUE_BREAK;
                        }
                        default -> null;
                    });
                    data.setBlockPosition(packet.getBlockPosition());
                    data.setFace(packet.getFace());
                    storage.getBlockInteractions().add(data);
                    wrapped.cancel();
                }
            }
        });
        this.registerServerbound(PlayerAuthInputPacket.class, wrapped -> {
            PlayerAuthInputPacket packet = (PlayerAuthInputPacket)wrapped.getPacket();
            BlockBreakingStorage storage = wrapped.session().get(BlockBreakingStorage.class);
            if (!storage.getBlockInteractions().isEmpty()) {
                packet.getInputData().add(PlayerAuthInputData.PERFORM_BLOCK_ACTIONS);
                packet.getPlayerActions().addAll(storage.getBlockInteractions());
                storage.getBlockInteractions().clear();
            }
        });
    }
}

