/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.handler.init;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.protocol.bedrock.BedrockPeer;
import org.cloudburstmc.protocol.bedrock.BedrockServerSession;
import org.cloudburstmc.protocol.bedrock.netty.initializer.BedrockServerInitializer;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.network.GeyserBedrockPeer;
import org.geysermc.geyser.network.InvalidPacketHandler;
import org.geysermc.geyser.session.GeyserSession;
import oxy.geyser.reversion.handler.TranslatorPacketHandler;

public class TranslatorServerInitializer
extends BedrockServerInitializer {
    private final GeyserImpl geyser;
    private final DefaultEventLoopGroup eventLoopGroup = new DefaultEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("Geyser player thread"));

    public TranslatorServerInitializer(GeyserImpl geyser) {
        this.geyser = geyser;
    }

    public void initSession(@NonNull BedrockServerSession bedrockServerSession) {
        try {
            InetSocketAddress address;
            if (this.geyser.getGeyserServer().getProxiedAddresses() != null && (address = (InetSocketAddress)this.geyser.getGeyserServer().getProxiedAddresses().get((Object)((InetSocketAddress)bedrockServerSession.getSocketAddress()))) != null) {
                ((GeyserBedrockPeer)bedrockServerSession.getPeer()).setProxiedAddress((SocketAddress)address);
            }
            bedrockServerSession.setLogging(true);
            GeyserSession session = new GeyserSession(this.geyser, bedrockServerSession, this.eventLoopGroup.next());
            Channel channel = bedrockServerSession.getPeer().getChannel();
            channel.pipeline().addAfter("bedrock-packet-codec", "rak-error-handler", (ChannelHandler)new InvalidPacketHandler(session));
            bedrockServerSession.setPacketHandler((BedrockPacketHandler)new TranslatorPacketHandler(this.geyser, session));
        }
        catch (Throwable e) {
            this.geyser.getLogger().error("Error occurred while initializing player!", e);
            bedrockServerSession.disconnect((CharSequence)e.getMessage());
        }
    }

    protected BedrockPeer createPeer(Channel channel) {
        return new GeyserBedrockPeer(channel, (x$0, x$1) -> (BedrockServerSession)this.createSession(x$0, x$1));
    }

    @Generated
    public DefaultEventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }
}

