/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.mappings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillClose;
import oxy.geyser.reversion.shaded.classtransform.mappings.AMapper;
import oxy.geyser.reversion.shaded.classtransform.mappings.MapperConfig;
import oxy.geyser.reversion.shaded.classtransform.utils.IOSupplier;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.MapRemapper;

@ParametersAreNonnullByDefault
public class TinyV2Mapper
extends AMapper {
    private final IOSupplier<InputStream> mappingsSupplier;
    private final String from;
    private final String to;

    public TinyV2Mapper(MapperConfig config, @WillClose InputStream mappingsStream, String from, String to) {
        super(config);
        this.mappingsSupplier = () -> mappingsStream;
        this.from = from;
        this.to = to;
    }

    public TinyV2Mapper(MapperConfig config, File mappingsFile, String from, String to) {
        super(config);
        this.mappingsSupplier = () -> new FileInputStream(mappingsFile);
        this.from = from;
        this.to = to;
    }

    @Override
    protected void init() throws Throwable {
        MapRemapper descriptorRemapper = new MapRemapper();
        ArrayList<TempMapping> tempMappings = new ArrayList<TempMapping>();
        List<String> lines = this.readLines(this.mappingsSupplier.get());
        int fromIndex = -1;
        int toIndex = -1;
        String currentClass = null;
        for (String line : lines) {
            String toName;
            String fromName;
            String descriptor;
            String trimmedLine = line.trim().replaceAll("\\s{2,}", "\t");
            if (trimmedLine.isEmpty()) continue;
            String[] parts = trimmedLine.split("\t");
            if (fromIndex == -1) {
                this.verifyHeader(parts);
                String[] mappingNames = Arrays.copyOfRange(parts, 3, parts.length);
                List<String> mappingNamesList = Arrays.asList(mappingNames);
                fromIndex = mappingNamesList.indexOf(this.from);
                toIndex = mappingNamesList.indexOf(this.to);
                if (fromIndex == -1) {
                    throw new IllegalArgumentException("Unable to find from mapping '" + this.from + "'");
                }
                if (toIndex != -1) continue;
                throw new IllegalArgumentException("Unable to find to mapping '" + this.to + "'");
            }
            if (line.startsWith("c\t")) {
                String baseName = parts[1];
                currentClass = parts[1 + fromIndex];
                String toName2 = parts[1 + toIndex];
                descriptorRemapper.addClassMapping(baseName, currentClass);
                this.remapper.addClassMapping(currentClass, toName2);
                this.classParsed(baseName, currentClass, toName2);
                continue;
            }
            if (line.startsWith("\tf\t")) {
                if (currentClass == null) {
                    throw new IllegalStateException("Field mapping without class mapping");
                }
                descriptor = parts[1];
                fromName = parts[2 + fromIndex];
                toName = parts[2 + toIndex];
                tempMappings.add(new TempMapping(false, currentClass, fromName, descriptor, toName));
                this.fieldParsed(currentClass, fromName, toName, descriptor);
                continue;
            }
            if (line.startsWith("\tm\t")) {
                if (currentClass == null) {
                    throw new IllegalStateException("Method mapping without class mapping");
                }
                descriptor = parts[1];
                fromName = parts[2 + fromIndex];
                toName = parts[2 + toIndex];
                tempMappings.add(new TempMapping(true, currentClass, fromName, descriptor, toName));
                this.methodParsed(currentClass, fromName, toName, descriptor);
                continue;
            }
            if (line.startsWith("\t\tp")) {
                this.parseParameter(currentClass, parts);
                continue;
            }
            if (trimmedLine.startsWith("c")) {
                this.parseComment(currentClass, line, parts);
                continue;
            }
            throw new IllegalStateException("Unknown line: " + line);
        }
        for (TempMapping tempMapping : tempMappings) {
            if (tempMapping.method) {
                this.remapper.addMethodMapping(tempMapping.owner, tempMapping.name, descriptorRemapper.mapMethodDesc(tempMapping.descriptor), tempMapping.newName);
                continue;
            }
            this.remapper.addFieldMapping(tempMapping.owner, tempMapping.name, descriptorRemapper.mapDesc(tempMapping.descriptor), tempMapping.newName);
        }
        this.postInit(descriptorRemapper);
    }

    private void verifyHeader(String[] parts) {
        if (!parts[0].equals("tiny")) {
            throw new IllegalStateException("Invalid tiny header (magic)");
        }
        if (!parts[1].equals("2")) {
            throw new IllegalStateException("Invalid tiny header (major version)");
        }
        if (!parts[2].equals("0")) {
            throw new IllegalStateException("Invalid tiny header (minor version)");
        }
        if (parts.length < 5) {
            throw new IllegalStateException("Invalid tiny header (missing columns)");
        }
    }

    protected void classParsed(String baseName, String fromName, String toName) {
    }

    protected void fieldParsed(@Nullable String currentClass, String fromName, String toName, String descriptor) {
    }

    protected void methodParsed(@Nullable String currentClass, String fromName, String toName, String descriptor) {
    }

    protected void parseParameter(@Nullable String currentClass, String[] parts) {
    }

    protected void parseComment(@Nullable String currentClass, String line, String[] parts) {
    }

    protected void postInit(MapRemapper descriptorRemapper) {
    }

    private static class TempMapping {
        private final boolean method;
        private final String owner;
        private final String name;
        private final String descriptor;
        private final String newName;

        private TempMapping(boolean method, String owner, String name, String descriptor, String newName) {
            this.method = method;
            this.owner = owner;
            this.name = name;
            this.descriptor = descriptor;
            this.newName = newName;
        }
    }
}

