/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.targets.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.FieldInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.annotations.CSlice;
import oxy.geyser.reversion.shaded.classtransform.annotations.CTarget;
import oxy.geyser.reversion.shaded.classtransform.targets.IInjectionTarget;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.MemberDeclaration;

@ParametersAreNonnullByDefault
public class FieldTarget
implements IInjectionTarget {
    private final int nonStaticAccess;
    private final int staticAccess;

    public FieldTarget() {
        this(-1, -1);
    }

    public FieldTarget(int nonStaticAccess, int staticAccess) {
        this.nonStaticAccess = nonStaticAccess;
        this.staticAccess = staticAccess;
    }

    @Override
    public List<AbstractInsnNode> getTargets(Map<String, IInjectionTarget> injectionTargets, MethodNode method, CTarget target, @Nullable CSlice slice) {
        ArrayList<AbstractInsnNode> targets = new ArrayList<AbstractInsnNode>();
        MemberDeclaration memberDeclaration = ASMUtils.splitMemberDeclaration(target.target());
        if (memberDeclaration == null) {
            return null;
        }
        boolean allAccess = this.nonStaticAccess == -1 && this.staticAccess == -1;
        int i = 0;
        for (AbstractInsnNode instruction : this.getSlice(injectionTargets, method, slice)) {
            if (!(instruction instanceof FieldInsnNode) || !allAccess && this.nonStaticAccess != instruction.getOpcode() && this.staticAccess != instruction.getOpcode()) continue;
            FieldInsnNode fieldInsnNode = (FieldInsnNode)instruction;
            if (!fieldInsnNode.owner.equals(memberDeclaration.getOwner()) || !fieldInsnNode.name.equals(memberDeclaration.getName()) || !fieldInsnNode.desc.equals(memberDeclaration.getDesc())) continue;
            if (target.ordinal() == -1 || target.ordinal() == i) {
                targets.add(instruction);
            }
            ++i;
        }
        return targets;
    }
}

