/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer.impl.general;

import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.FieldNode;
import oxy.geyser.reversion.shaded.asm.tree.InnerClassNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.classtransform.annotations.CShadow;
import oxy.geyser.reversion.shaded.classtransform.transformer.AnnotationHandler;
import oxy.geyser.reversion.shaded.classtransform.transformer.impl.general.SyntheticMethodGeneralHandler;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.annotations.AnnotationUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.MapRemapper;
import oxy.geyser.reversion.shaded.classtransform.utils.mappings.Remapper;

@ParametersAreNonnullByDefault
public class InnerClassGeneralHandler
extends AnnotationHandler {
    @Override
    public void transform(TransformerManager transformerManager, ClassNode injectedClass, ClassNode transformer) {
        ClassNode fInjectedClass = ASMUtils.cloneClass(injectedClass);
        ClassNode fTransformer = ASMUtils.cloneClass(transformer);
        boolean hasInnerClasses = false;
        for (InnerClassNode innerClass : transformer.innerClasses) {
            if (innerClass.outerName != null) continue;
            hasInnerClasses = true;
            transformerManager.addRawTransformer(ASMUtils.dot(innerClass.name), (tm, transformedClass) -> {
                for (FieldNode field : transformedClass.fields) {
                    field.access = ASMUtils.setAccess(field.access, 1);
                }
                for (MethodNode method : transformedClass.methods) {
                    method.access = ASMUtils.setAccess(method.access, 1);
                }
                transformedClass.access = ASMUtils.setAccess(transformedClass.access, 1);
                transformedClass.outerClass = null;
                MapRemapper remapper = new MapRemapper();
                remapper.addClassMapping(fTransformer.name, fInjectedClass.name);
                SyntheticMethodGeneralHandler.fillSyntheticMappings(fTransformer, fInjectedClass, remapper);
                return Remapper.remap(transformedClass, remapper);
            });
        }
        if (hasInnerClasses) {
            this.makeFieldsPublic(transformer);
            this.makeMethodsPublic(transformer);
        }
    }

    private void makeFieldsPublic(ClassNode transformer) {
        for (FieldNode field : transformer.fields) {
            field.access = ASMUtils.setAccess(field.access, 1);
            AnnotationUtils.findAnnotation(field, CShadow.class).ifPresent(annotation -> {
                Map<String, Object> values = AnnotationUtils.listToMap(annotation.values);
                values.put("makePublic", true);
                annotation.values = AnnotationUtils.mapToList(values);
            });
        }
    }

    private void makeMethodsPublic(ClassNode transformer) {
        for (MethodNode method : transformer.methods) {
            method.access = ASMUtils.setAccess(method.access, 1);
            method.access &= 0xFFFFFFBF;
            AnnotationUtils.findAnnotation(method, CShadow.class).ifPresent(annotation -> {
                Map<String, Object> values = AnnotationUtils.listToMap(annotation.values);
                values.put("makePublic", true);
                annotation.values = AnnotationUtils.mapToList(values);
            });
        }
    }
}

