/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.transformer.impl.wrapcondition;

import java.lang.reflect.Modifier;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.InsnList;
import oxy.geyser.reversion.shaded.asm.tree.JumpInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.LabelNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.asm.tree.VarInsnNode;
import oxy.geyser.reversion.shaded.classtransform.exceptions.TransformerException;
import oxy.geyser.reversion.shaded.classtransform.transformer.impl.wrapcondition.IWrapConditionTarget;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.Codifier;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

public class CWrapConditionMethod
implements IWrapConditionTarget<MethodInsnNode> {
    @Override
    public MethodInsnNode inject(ClassNode transformedClass, ClassNode transformer, MethodNode transformerMethod, MethodNode target, MethodInsnNode insnNode) {
        int i;
        boolean isStatic;
        boolean hasArgs = Types.argumentTypes(transformerMethod).length > 0;
        Type[] argumentTypes = Types.argumentTypes(insnNode.desc);
        boolean bl = isStatic = insnNode.getOpcode() == 184;
        if (hasArgs) {
            Type[] expectedArgs;
            if (isStatic) {
                expectedArgs = argumentTypes;
            } else {
                expectedArgs = new Type[argumentTypes.length + 1];
                expectedArgs[0] = Types.type(insnNode.owner);
                System.arraycopy(argumentTypes, 0, expectedArgs, 1, argumentTypes.length);
            }
            if (!ASMUtils.compareTypes(expectedArgs, Types.argumentTypes(transformerMethod))) {
                String message = "must have ";
                message = expectedArgs.length == 1 ? message + "the arguments of the target method" : message + "the instance of the method owner and the arguments of the target method";
                throw new TransformerException(transformerMethod, transformer, message + " as arguments").help(Codifier.of(transformerMethod).param(null).params(expectedArgs));
            }
        }
        int instanceIndex = ASMUtils.getFreeVarIndex(target);
        int[] argIndices = new int[argumentTypes.length];
        for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
            int last = i2 == 0 ? instanceIndex : argIndices[i2 - 1];
            argIndices[i2] = last + argumentTypes[i2].getSize();
        }
        LabelNode end = new LabelNode();
        InsnList insns = new InsnList();
        for (i = argumentTypes.length - 1; i >= 0; --i) {
            insns.add(new VarInsnNode(argumentTypes[i].getOpcode(54), argIndices[i]));
        }
        if (!isStatic) {
            insns.add(new VarInsnNode(58, instanceIndex));
        }
        if (!Modifier.isStatic(target.access)) {
            insns.add(new VarInsnNode(25, 0));
        }
        if (hasArgs) {
            if (!isStatic) {
                insns.add(new VarInsnNode(25, instanceIndex));
            }
            for (i = 0; i < argumentTypes.length; ++i) {
                insns.add(new VarInsnNode(argumentTypes[i].getOpcode(21), argIndices[i]));
            }
        }
        MethodInsnNode transformerCall = Modifier.isStatic(target.access) ? new MethodInsnNode(184, transformedClass.name, transformerMethod.name, transformerMethod.desc, Modifier.isInterface(transformedClass.access)) : new MethodInsnNode(Modifier.isInterface(transformedClass.access) ? 185 : 182, transformedClass.name, transformerMethod.name, transformerMethod.desc);
        insns.add(transformerCall);
        insns.add(new JumpInsnNode(153, end));
        if (!isStatic) {
            insns.add(new VarInsnNode(25, instanceIndex));
        }
        for (int i3 = 0; i3 < argumentTypes.length; ++i3) {
            insns.add(new VarInsnNode(argumentTypes[i3].getOpcode(21), argIndices[i3]));
        }
        target.instructions.insertBefore((AbstractInsnNode)insnNode, insns);
        target.instructions.insert((AbstractInsnNode)insnNode, end);
        return transformerCall;
    }
}

