/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils;

import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.tree.AbstractInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.ClassNode;
import oxy.geyser.reversion.shaded.asm.tree.FieldInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.InsnList;
import oxy.geyser.reversion.shaded.asm.tree.InsnNode;
import oxy.geyser.reversion.shaded.asm.tree.JumpInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.LabelNode;
import oxy.geyser.reversion.shaded.asm.tree.LdcInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.MethodNode;
import oxy.geyser.reversion.shaded.asm.tree.TypeInsnNode;
import oxy.geyser.reversion.shaded.asm.tree.VarInsnNode;
import oxy.geyser.reversion.shaded.classtransform.InjectionCallback;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

public class InjectionCallbackReplacer {
    public static void replaceCallback(ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            InjectionCallbackReplacer.replaceParameters(method);
            InjectionCallbackReplacer.replaceConstructor(method);
            InjectionCallbackReplacer.replaceInvokes(method);
        }
    }

    private static void replaceParameters(MethodNode methodNode) {
        Type injectionCallback = Types.type(InjectionCallback.class);
        Type objectArray = Types.type(Object[].class);
        if (methodNode.signature != null && methodNode.signature.contains(injectionCallback.getDescriptor())) {
            methodNode.signature = methodNode.signature.replace(injectionCallback.getDescriptor(), objectArray.getDescriptor());
        }
        methodNode.desc = InjectionCallbackReplacer.replaceParameter(methodNode.desc, injectionCallback, objectArray);
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            methodInsn.desc = InjectionCallbackReplacer.replaceParameter(methodInsn.desc, injectionCallback, objectArray);
        }
    }

    private static void replaceConstructor(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            InsnList replacement;
            if (insn.getOpcode() == 187) {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                if (!typeInsn.desc.equals(Types.internalName(InjectionCallback.class))) continue;
                replacement = new InsnList();
                replacement.add(ASMUtils.intPush(4));
                replacement.add(new TypeInsnNode(189, Types.internalName(Object.class)));
                methodNode.instructions.insertBefore((AbstractInsnNode)typeInsn, replacement);
                methodNode.instructions.remove(typeInsn);
                continue;
            }
            if (insn.getOpcode() != 183) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!methodInsn.owner.equals(Types.internalName(InjectionCallback.class))) continue;
            if (!methodInsn.name.equals("<init>")) {
                throw new UnsupportedOperationException("Unknown InjectionCallback constructor: " + methodInsn.name);
            }
            replacement = new InsnList();
            if (methodInsn.desc.equals(Types.methodDescriptor(Void.TYPE, Boolean.TYPE))) {
                replacement.add(new InsnNode(95));
                replacement.add(new InsnNode(90));
                replacement.add(new InsnNode(95));
                replacement.add(ASMUtils.intPush(0));
                replacement.add(new InsnNode(95));
                replacement.add(ASMUtils.getPrimitiveToObject(Type.BOOLEAN_TYPE));
                replacement.add(new InsnNode(83));
                replacement.add(new InsnNode(89));
                replacement.add(ASMUtils.intPush(1));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "FALSE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
                replacement.add(ASMUtils.intPush(3));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "FALSE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
            } else if (methodInsn.desc.equals(Types.methodDescriptor(Void.TYPE, Boolean.TYPE, Object.class))) {
                replacement.add(new InsnNode(91));
                replacement.add(new InsnNode(87));
                replacement.add(new InsnNode(95));
                replacement.add(new InsnNode(91));
                replacement.add(new InsnNode(95));
                replacement.add(ASMUtils.intPush(0));
                replacement.add(new InsnNode(95));
                replacement.add(ASMUtils.getPrimitiveToObject(Type.BOOLEAN_TYPE));
                replacement.add(new InsnNode(83));
                replacement.add(new InsnNode(95));
                replacement.add(new InsnNode(90));
                replacement.add(new InsnNode(95));
                replacement.add(ASMUtils.intPush(2));
                replacement.add(new InsnNode(95));
                replacement.add(new InsnNode(83));
                replacement.add(new InsnNode(89));
                replacement.add(ASMUtils.intPush(1));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "FALSE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
                replacement.add(ASMUtils.intPush(3));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "TRUE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
            } else {
                throw new UnsupportedOperationException("Unknown InjectionCallback constructor: " + methodInsn.desc);
            }
            methodNode.instructions.insertBefore((AbstractInsnNode)methodInsn, replacement);
            methodNode.instructions.remove(methodInsn);
        }
    }

    private static void replaceInvokes(MethodNode methodNode) {
        for (AbstractInsnNode insn : methodNode.instructions.toArray()) {
            LabelNode elseLabel;
            int arrayIndex;
            if (insn.getOpcode() != 182) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!methodInsn.owner.equals(Types.internalName(InjectionCallback.class))) continue;
            InsnList replacement = new InsnList();
            if (methodInsn.name.equals("isCancelled")) {
                replacement.add(ASMUtils.intPush(1));
                replacement.add(new InsnNode(50));
                replacement.add(ASMUtils.getCast(Type.BOOLEAN_TYPE));
            } else if (methodInsn.name.equals("setCancelled")) {
                arrayIndex = ASMUtils.getFreeVarIndex(methodNode);
                int booleanIndex = arrayIndex + 1;
                replacement.add(new VarInsnNode(54, booleanIndex));
                replacement.add(new VarInsnNode(58, arrayIndex));
                elseLabel = new LabelNode();
                replacement.add(new VarInsnNode(21, booleanIndex));
                replacement.add(new JumpInsnNode(153, elseLabel));
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(0));
                replacement.add(new InsnNode(50));
                replacement.add(ASMUtils.getCast(Type.BOOLEAN_TYPE));
                replacement.add(new JumpInsnNode(154, elseLabel));
                replacement.add(new TypeInsnNode(187, Types.internalName(IllegalArgumentException.class)));
                replacement.add(new InsnNode(89));
                replacement.add(new LdcInsnNode("Cannot cancel a non-cancellable callback"));
                replacement.add(new MethodInsnNode(183, Types.internalName(IllegalArgumentException.class), "<init>", Types.methodDescriptor(Void.TYPE, String.class), false));
                replacement.add(new InsnNode(191));
                replacement.add(elseLabel);
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(1));
                replacement.add(new VarInsnNode(21, booleanIndex));
                replacement.add(ASMUtils.getPrimitiveToObject(Type.BOOLEAN_TYPE));
                replacement.add(new InsnNode(83));
            } else if (methodInsn.name.equals("isCancellable")) {
                replacement.add(ASMUtils.intPush(0));
                replacement.add(new InsnNode(50));
                replacement.add(ASMUtils.getCast(Type.BOOLEAN_TYPE));
            } else if (methodInsn.name.equals("getReturnValue") || methodInsn.name.equals("castReturnValue")) {
                arrayIndex = ASMUtils.getFreeVarIndex(methodNode);
                replacement.add(new VarInsnNode(58, arrayIndex));
                LabelNode elseLabel2 = new LabelNode();
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(3));
                replacement.add(new InsnNode(50));
                replacement.add(ASMUtils.getCast(Type.BOOLEAN_TYPE));
                replacement.add(new JumpInsnNode(154, elseLabel2));
                replacement.add(new TypeInsnNode(187, Types.internalName(IllegalStateException.class)));
                replacement.add(new InsnNode(89));
                replacement.add(new LdcInsnNode("Return value not set"));
                replacement.add(new MethodInsnNode(183, Types.internalName(IllegalStateException.class), "<init>", Types.methodDescriptor(Void.TYPE, String.class), false));
                replacement.add(new InsnNode(191));
                replacement.add(elseLabel2);
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(2));
                replacement.add(new InsnNode(50));
            } else if (methodInsn.name.equals("setReturnValue")) {
                arrayIndex = ASMUtils.getFreeVarIndex(methodNode);
                int objectIndex = arrayIndex + 1;
                replacement.add(new VarInsnNode(58, objectIndex));
                replacement.add(new VarInsnNode(58, arrayIndex));
                elseLabel = new LabelNode();
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(0));
                replacement.add(new InsnNode(50));
                replacement.add(ASMUtils.getCast(Type.BOOLEAN_TYPE));
                replacement.add(new JumpInsnNode(154, elseLabel));
                replacement.add(new TypeInsnNode(187, Types.internalName(IllegalStateException.class)));
                replacement.add(new InsnNode(89));
                replacement.add(new LdcInsnNode("Cannot cancel a non-cancellable callback"));
                replacement.add(new MethodInsnNode(183, Types.internalName(IllegalStateException.class), "<init>", Types.methodDescriptor(Void.TYPE, String.class), false));
                replacement.add(new InsnNode(191));
                replacement.add(elseLabel);
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(1));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "TRUE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(2));
                replacement.add(new VarInsnNode(25, objectIndex));
                replacement.add(new InsnNode(83));
                replacement.add(new VarInsnNode(25, arrayIndex));
                replacement.add(ASMUtils.intPush(3));
                replacement.add(new FieldInsnNode(178, Types.internalName(Boolean.class), "TRUE", Types.typeDescriptor(Boolean.class)));
                replacement.add(new InsnNode(83));
            } else {
                throw new UnsupportedOperationException("Unknown InjectionCallback method: " + methodInsn.name);
            }
            methodNode.instructions.insertBefore((AbstractInsnNode)methodInsn, replacement);
            methodNode.instructions.remove(methodInsn);
        }
    }

    private static String replaceParameter(String methodDescriptor, Type toReplace, Type replacement) {
        Type returnType = Types.returnType(methodDescriptor);
        Type[] parameterTypes = Types.argumentTypes(methodDescriptor);
        if (returnType.equals(toReplace)) {
            returnType = replacement;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!parameterTypes[i].equals(toReplace)) continue;
            parameterTypes[i] = replacement;
        }
        return Types.methodDescriptor(returnType, parameterTypes);
    }
}

