/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils.annotations;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.classtransform.utils.ASMUtils;
import sun.misc.Unsafe;

@ParametersAreNonnullByDefault
public class ClassDefiner<T> {
    private static Unsafe UNSAFE;
    private final Class<T> clazz;

    private static Unsafe getUnsafe() {
        if (UNSAFE == null) {
            for (Field field : Unsafe.class.getDeclaredFields()) {
                if (field.getType() != Unsafe.class) continue;
                field.setAccessible(true);
                try {
                    UNSAFE = (Unsafe)field.get(null);
                    break;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Unable to get unsafe instance", t);
                }
            }
        }
        return UNSAFE;
    }

    public static String generateClassName(String name) {
        return ASMUtils.slash(ClassDefiner.class.getPackage().getName()) + "/" + name;
    }

    public static <T> ClassDefiner<T> defineAnonymousClass(byte[] bytecode) {
        try {
            Method defineAnonymousClass = Unsafe.class.getDeclaredMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);
            return new ClassDefiner<T>((Class)defineAnonymousClass.invoke((Object)ClassDefiner.getUnsafe(), ClassDefiner.class, bytecode, new Object[0]));
        }
        catch (Throwable t) {
            Throwable error = t;
            try {
                Class<?> classOptionClass = Class.forName("java.lang.invoke.MethodHandles$Lookup$ClassOption");
                Object emptyClassOptionArray = Array.newInstance(classOptionClass, 0);
                Method lookupDefineHiddenClass = MethodHandles.Lookup.class.getDeclaredMethod("defineHiddenClass", byte[].class, Boolean.TYPE, emptyClassOptionArray.getClass());
                MethodHandles.Lookup lookup = (MethodHandles.Lookup)lookupDefineHiddenClass.invoke((Object)MethodHandles.lookup(), bytecode, false, emptyClassOptionArray);
                return new ClassDefiner<T>(lookup.lookupClass());
            }
            catch (Throwable t2) {
                t2.addSuppressed(error);
                error = t2;
                throw new RuntimeException("Unable to define anonymous class", error);
            }
        }
    }

    private ClassDefiner(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public T newInstance() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return this.newInstance(new Object[0]);
    }

    public T newInstance(Object ... args) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getClass();
        }
        return this.newInstance(types, args);
    }

    public T newInstance(Class<?>[] types, Object[] values) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (types.length != values.length) {
            throw new IllegalArgumentException("Types and values must be of the same length");
        }
        Constructor<T> constructor = this.clazz.getDeclaredConstructor(types);
        constructor.setAccessible(true);
        return constructor.newInstance(values);
    }
}

