/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.classtransform.utils.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import oxy.geyser.reversion.shaded.asm.Type;
import oxy.geyser.reversion.shaded.asm.commons.Remapper;
import oxy.geyser.reversion.shaded.classtransform.utils.Types;

@ParametersAreNonnullByDefault
public class MapRemapper
extends Remapper {
    private final Map<String, String> mappings;
    private MapRemapper reverse;

    public MapRemapper() {
        this(new HashMap<String, String>());
    }

    public MapRemapper(String oldName, String newName) {
        this();
        this.mappings.put(oldName, newName);
    }

    public MapRemapper(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.mappings);
    }

    public void addClassMapping(String from, String to) {
        this.addClassMapping(from, to, false);
    }

    public void addClassMapping(String from, String to, boolean skipIfExists) {
        if (skipIfExists && this.mappings.containsKey(from)) {
            return;
        }
        this.mappings.put(from, to);
        if (this.reverse != null) {
            this.reverse.reverse = null;
            this.reverse = null;
        }
    }

    public void addMethodMapping(String owner, String name, String desc, String target) {
        this.addMethodMapping(owner, name, desc, target, false);
    }

    public void addMethodMapping(String owner, String name, String desc, String target, boolean skipIfExists) {
        String key = owner + "." + name + desc;
        if (skipIfExists && this.mappings.containsKey(key)) {
            return;
        }
        this.mappings.put(key, target);
        if (this.reverse != null) {
            this.reverse.reverse = null;
            this.reverse = null;
        }
    }

    public void addFieldMapping(String owner, String name, String target) {
        this.addFieldMapping(owner, name, target, false);
    }

    public void addFieldMapping(String owner, String name, String target, boolean skipIfExists) {
        this.addFieldMapping(owner, name, "", target, skipIfExists);
    }

    public void addFieldMapping(String owner, String name, String desc, String target) {
        this.addFieldMapping(owner, name, desc, target, false);
    }

    public void addFieldMapping(String owner, String name, String desc, String target, boolean skipIfExists) {
        String key = owner + "." + name + ":" + desc;
        if (skipIfExists && this.mappings.containsKey(key)) {
            return;
        }
        this.mappings.put(key, target);
        if (this.reverse != null) {
            this.reverse.reverse = null;
            this.reverse = null;
        }
    }

    public List<String> getStartingMappings(String ... prefixes) {
        ArrayList<String> mappings = new ArrayList<String>();
        for (String mapping : this.mappings.keySet()) {
            for (String start : prefixes) {
                if (!mapping.startsWith(start)) continue;
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public void copy(MapRemapper remapper) {
        this.mappings.putAll(remapper.mappings);
    }

    @Override
    @Nonnull
    public String mapMethodName(String owner, String name, String descriptor) {
        String remappedName = this.map(owner + '.' + name + descriptor);
        return remappedName == null ? name : remappedName;
    }

    @Override
    @Nonnull
    public String mapInvokeDynamicMethodName(String name, String descriptor) {
        String remappedName = this.map('.' + name + descriptor);
        return remappedName == null ? name : remappedName;
    }

    @Override
    @Nonnull
    public String mapAnnotationAttributeName(String descriptor, String name) {
        String remappedName = this.map(descriptor + '.' + name);
        return remappedName == null ? name : remappedName;
    }

    @Override
    @Nonnull
    public String mapFieldName(String owner, String name, String descriptor) {
        String remappedName = this.map(owner + '.' + name + ':' + descriptor);
        if (remappedName == null) {
            remappedName = this.map(owner + '.' + name + ":");
        }
        return remappedName == null ? name : remappedName;
    }

    @Override
    @Nullable
    public String map(String key) {
        return this.mappings.get(key);
    }

    @Nonnull
    public String mapSafe(String key) {
        return this.mappings.getOrDefault(key, key);
    }

    @Nonnull
    public Set<String> getMentionedClasses() {
        HashSet<String> classes = new HashSet<String>();
        HashSet<Type> types = new HashSet<Type>();
        for (String mapping : this.mappings.keySet()) {
            if (mapping.contains(".")) {
                String desc;
                String owner;
                if (mapping.contains(":")) {
                    owner = mapping.substring(0, mapping.indexOf("."));
                    desc = mapping.substring(mapping.indexOf(":") + 1);
                    classes.add(owner);
                    types.add(Types.type(desc));
                    continue;
                }
                owner = mapping.substring(0, mapping.indexOf("."));
                desc = mapping.substring(mapping.indexOf("("));
                classes.add(owner);
                Type[] args = Types.argumentTypes(desc);
                types.addAll(Arrays.asList(args));
                types.add(Types.returnType(desc));
                continue;
            }
            classes.add(mapping);
        }
        for (Type type : types) {
            if (type.getSort() == 9) {
                type = type.getElementType();
            }
            if (type.getSort() != 10) continue;
            classes.add(type.getInternalName());
        }
        return classes;
    }

    @Nonnull
    public MapRemapper reverse() {
        if (this.reverse != null) {
            return this.reverse;
        }
        MapRemapper reverseRemapper = new MapRemapper();
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            if (entry.getKey().contains(".")) continue;
            reverseRemapper.addClassMapping(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            String mappedName;
            String desc;
            String name;
            String owner;
            if (!entry.getKey().contains(".")) continue;
            if (entry.getKey().contains(":")) {
                String fieldMapping = entry.getKey();
                owner = fieldMapping.substring(0, fieldMapping.indexOf("."));
                name = fieldMapping.substring(fieldMapping.indexOf(".") + 1, fieldMapping.indexOf(":"));
                desc = fieldMapping.substring(fieldMapping.indexOf(":") + 1);
                mappedName = entry.getValue();
                if (desc.isEmpty()) {
                    reverseRemapper.addFieldMapping(this.mapSafe(owner), mappedName, name);
                    continue;
                }
                reverseRemapper.addFieldMapping(this.mapSafe(owner), mappedName, this.mapDesc(desc), name);
                continue;
            }
            String methodMapping = entry.getKey();
            owner = methodMapping.substring(0, methodMapping.indexOf("."));
            name = methodMapping.substring(methodMapping.indexOf(".") + 1, methodMapping.indexOf("("));
            desc = methodMapping.substring(methodMapping.indexOf("("));
            mappedName = entry.getValue();
            reverseRemapper.addMethodMapping(this.mapSafe(owner), mappedName, this.mapMethodDesc(desc), name);
        }
        reverseRemapper.reverse = this;
        this.reverse = reverseRemapper;
        return this.reverse;
    }
}

