/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.reflect.stream.constructor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Stream;
import oxy.geyser.reversion.shaded.reflect.Constructors;
import oxy.geyser.reversion.shaded.reflect.stream.RStream;
import oxy.geyser.reversion.shaded.reflect.stream.constructor.ConstructorStream;
import oxy.geyser.reversion.shaded.reflect.stream.general.ModifierWrapper;

public class ConstructorWrapper {
    private final ConstructorStream parent;
    private final Constructor<?> constructor;
    private final ModifierWrapper modifier;

    public ConstructorWrapper(ConstructorStream parent, Constructor<?> constructor) {
        this.parent = parent;
        this.constructor = constructor;
        this.modifier = new ModifierWrapper(constructor.getModifiers());
    }

    public ConstructorStream parent() {
        return this.parent;
    }

    public Constructor<?> raw() {
        return this.constructor;
    }

    public Class<?>[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public int parameterCount() {
        return this.constructor.getParameterCount();
    }

    public Class<?> owner() {
        return this.constructor.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public Stream<Annotation> annotations() {
        return Arrays.stream(this.constructor.getDeclaredAnnotations());
    }

    public <T> T newInstance(Object ... args) {
        return (T)Constructors.invoke(this.constructor, args);
    }

    public RStream streamInstance(Object ... args) {
        return RStream.of(this.newInstance(args));
    }

    public RStream streamInstance(Class<?> clazz, Object ... args) {
        return RStream.of(clazz, this.newInstance(args));
    }

    public String toString() {
        return this.constructor.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstructorWrapper) {
            return this.constructor.equals(((ConstructorWrapper)obj).constructor);
        }
        if (obj instanceof Constructor) {
            return this.constructor.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.constructor.hashCode();
    }
}

