/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.util;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import org.cloudburstmc.protocol.bedrock.data.auth.AuthPayload;
import org.cloudburstmc.protocol.bedrock.data.auth.CertificateChainPayload;
import org.cloudburstmc.protocol.bedrock.data.auth.TokenPayload;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.LoginPacket;
import org.cloudburstmc.protocol.bedrock.packet.ServerToClientHandshakePacket;
import org.cloudburstmc.protocol.bedrock.util.ChainValidationResult;
import org.cloudburstmc.protocol.bedrock.util.EncryptionUtils;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.auth.AuthData;
import org.geysermc.geyser.text.GeyserLocale;
import oxy.geyser.reversion.shaded.jackson.databind.DeserializationFeature;
import oxy.geyser.reversion.shaded.jackson.databind.JsonNode;
import oxy.geyser.reversion.shaded.jackson.databind.ObjectMapper;
import oxy.geyser.reversion.util.duplicated.OtherBedrockClientData;

public class ClientDataUtil {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static boolean HAS_SENT_ENCRYPTION_MESSAGE = false;

    public static void setClientData(GeyserSession session, LoginPacket packet) {
        try {
            GeyserImpl geyser = session.getGeyser();
            ChainValidationResult result = EncryptionUtils.validatePayload((AuthPayload)packet.getAuthPayload());
            Long rawIssuedAt = (Long)result.rawIdentityClaims().get("iat");
            long issuedAt = rawIssuedAt != null ? rawIssuedAt : -1L;
            ChainValidationResult.IdentityData extraData = result.identityClaims().extraData;
            session.setAuthData(new AuthData(extraData.displayName, extraData.identity, extraData.xuid, issuedAt));
            AuthPayload authPayload = packet.getAuthPayload();
            if (authPayload instanceof TokenPayload) {
                TokenPayload tokenPayload = (TokenPayload)authPayload;
                session.setToken(tokenPayload.getToken());
            } else {
                authPayload = packet.getAuthPayload();
                if (authPayload instanceof CertificateChainPayload) {
                    CertificateChainPayload certificateChainPayload = (CertificateChainPayload)authPayload;
                    session.setCertChainData(certificateChainPayload.getChain());
                } else {
                    GeyserImpl.getInstance().getLogger().warning("Unknown auth payload! Skin uploading will not work");
                }
            }
            PublicKey identityPublicKey = result.identityClaims().parsedIdentityPublicKey();
            byte[] clientDataPayload = EncryptionUtils.verifyClientData((String)packet.getClientJwt(), (PublicKey)identityPublicKey);
            if (clientDataPayload == null) {
                throw new IllegalStateException("Client data isn't signed by the given chain data");
            }
            JsonNode clientDataJson = JSON_MAPPER.readTree(clientDataPayload);
            OtherBedrockClientData data = JSON_MAPPER.convertValue((Object)clientDataJson, OtherBedrockClientData.class);
            data.setOriginalString(packet.getClientJwt());
            session.setClientData(data.toGeyser());
            try {
                ClientDataUtil.startEncryptionHandshake(session, identityPublicKey);
            }
            catch (Throwable e) {
                if (geyser.getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                ClientDataUtil.sendEncryptionFailedMessage(geyser);
            }
        }
        catch (Exception ex) {
            session.disconnect("disconnectionScreen.internalError.cantConnect");
            throw new RuntimeException("Unable to complete login", ex);
        }
    }

    private static void startEncryptionHandshake(GeyserSession session, PublicKey key) throws Exception {
        KeyPair serverKeyPair = EncryptionUtils.createKeyPair();
        byte[] token = EncryptionUtils.generateRandomToken();
        ServerToClientHandshakePacket packet = new ServerToClientHandshakePacket();
        packet.setJwt(EncryptionUtils.createHandshakeJwt((KeyPair)serverKeyPair, (byte[])token));
        session.sendUpstreamPacketImmediately((BedrockPacket)packet);
        SecretKey encryptionKey = EncryptionUtils.getSecretKey((PrivateKey)serverKeyPair.getPrivate(), (PublicKey)key, (byte[])token);
        session.getUpstream().getSession().enableEncryption(encryptionKey);
    }

    private static void sendEncryptionFailedMessage(GeyserImpl geyser) {
        if (!HAS_SENT_ENCRYPTION_MESSAGE) {
            geyser.getLogger().warning(GeyserLocale.getLocaleStringLog((String)"geyser.network.encryption.line_1"));
            geyser.getLogger().warning(GeyserLocale.getLocaleStringLog((String)"geyser.network.encryption.line_2", (Object[])new Object[]{"https://geysermc.org/supported_java"}));
            HAS_SENT_ENCRYPTION_MESSAGE = true;
        }
    }
}

