/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.data.bedrock.item.upgrade;

import com.github.blackjack200.ouranos.ProtocolInfo;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.ItemIdMetaUpgradeSchema;
import com.github.blackjack200.ouranos.data.bedrock.item.upgrade.model.ItemIdMetaUpgradeSchemaModel;
import com.github.blackjack200.ouranos.shaded.gson.Gson;
import com.github.blackjack200.ouranos.shaded.gson.JsonElement;
import com.github.blackjack200.ouranos.shaded.gson.JsonObject;
import com.github.blackjack200.ouranos.shaded.gson.JsonSyntaxException;
import com.github.blackjack200.ouranos.shaded.lombok.Generated;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ItemIdMetaUpgradeSchemaUtils {
    private static final Gson GSON = new Gson();
    private static final String JSON_FILE_PATTERN = "^(\\d{4}).*\\.json$";
    private static final String JAR_PATH_PREFIX = "file:";
    private static final String JAR_PATH_SUFFIX = ".jar!";

    public static Map<Integer, ItemIdMetaUpgradeSchema> loadSchemas(String path, int maxSchemaId) throws IOException {
        TreeMap<Integer, ItemIdMetaUpgradeSchema> result = new TreeMap<Integer, ItemIdMetaUpgradeSchema>();
        URL resourceUrl = ProtocolInfo.class.getClassLoader().getResource(path);
        if (resourceUrl == null) {
            throw new IOException("The specified path does not exist: " + path);
        }
        String resourcePath = resourceUrl.getPath();
        if (resourcePath.contains(JAR_PATH_SUFFIX)) {
            ItemIdMetaUpgradeSchemaUtils.loadSchemasFromJar(resourcePath, path, maxSchemaId, result);
        } else {
            ItemIdMetaUpgradeSchemaUtils.loadSchemasFromFileSystem(resourcePath, maxSchemaId, result);
        }
        return result;
    }

    private static void loadSchemasFromJar(String resourcePath, String path, int maxSchemaId, Map<Integer, ItemIdMetaUpgradeSchema> result) throws IOException {
        String jarPath = resourcePath.substring(JAR_PATH_PREFIX.length(), resourcePath.indexOf(JAR_PATH_SUFFIX) + 4);
        jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(path) || !entry.getName().matches(".*\\d{4}.*\\.json$")) continue;
                ItemIdMetaUpgradeSchemaUtils.processSchemaEntry(jarFile, entry, maxSchemaId, result);
            }
        }
    }

    private static void loadSchemasFromFileSystem(String resourcePath, int maxSchemaId, Map<Integer, ItemIdMetaUpgradeSchema> result) throws IOException {
        File dir = new File(URLDecoder.decode(resourcePath, StandardCharsets.UTF_8));
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IOException("The specified path is not a valid directory: " + resourcePath);
        }
        File[] files = dir.listFiles((dir1, name) -> name.matches(JSON_FILE_PATTERN));
        if (files == null) {
            throw new IOException("Error reading the directory contents: " + resourcePath);
        }
        for (File file : files) {
            ItemIdMetaUpgradeSchemaUtils.processSchemaFile(file, maxSchemaId, result);
        }
    }

    private static void processSchemaEntry(JarFile jarFile, JarEntry entry, int maxSchemaId, Map<Integer, ItemIdMetaUpgradeSchema> result) throws IOException {
        int schemaId;
        Pattern pattern = Pattern.compile(".*/(\\d{4}).*\\.json$");
        Matcher matcher = pattern.matcher(entry.getName());
        if (matcher.find() && (schemaId = Integer.parseInt(matcher.group(1))) <= maxSchemaId) {
            try (InputStream inputStream = jarFile.getInputStream(entry);
                 InputStreamReader reader = new InputStreamReader(inputStream);){
                ItemIdMetaUpgradeSchemaUtils.loadSchemaFromStream(reader, schemaId, result);
            }
        }
    }

    private static void processSchemaFile(File file, int maxSchemaId, Map<Integer, ItemIdMetaUpgradeSchema> result) throws IOException {
        int schemaId;
        String filename = file.getName();
        Pattern pattern = Pattern.compile(JSON_FILE_PATTERN);
        Matcher matcher = pattern.matcher(filename);
        if (matcher.find() && (schemaId = Integer.parseInt(matcher.group(1))) <= maxSchemaId) {
            try (FileReader reader = new FileReader(file);){
                ItemIdMetaUpgradeSchemaUtils.loadSchemaFromStream(reader, schemaId, result);
            }
        }
    }

    private static void loadSchemaFromStream(Reader reader, int schemaId, Map<Integer, ItemIdMetaUpgradeSchema> result) throws IOException {
        try {
            JsonElement jsonElement = GSON.fromJson(reader, JsonElement.class);
            ItemIdMetaUpgradeSchema schema = ItemIdMetaUpgradeSchemaUtils.loadSchemaFromJson(jsonElement, schemaId);
            result.put(schemaId, schema);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("Failed to parse schema file: " + e.getMessage(), e);
        }
    }

    public static ItemIdMetaUpgradeSchema loadSchemaFromJson(JsonElement jsonElement, int schemaId) {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Unexpected root type of schema file, expected object");
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        ItemIdMetaUpgradeSchemaModel model = GSON.fromJson((JsonElement)jsonObject, ItemIdMetaUpgradeSchemaModel.class);
        return new ItemIdMetaUpgradeSchema(model.getRenamedIds(), model.getRemappedMetas(), schemaId);
    }

    @Generated
    private ItemIdMetaUpgradeSchemaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

