/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.comparator;

import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class IndexedComparator<T>
implements Comparator<T> {
    private final boolean atEndIfMiss;
    private final Map<? super T, Integer> map;

    public IndexedComparator(T ... objs) {
        this(false, objs);
    }

    private IndexedComparator(boolean atEndIfMiss, Map<? super T, Integer> map) {
        this.atEndIfMiss = atEndIfMiss;
        this.map = map;
    }

    public IndexedComparator(boolean atEndIfMiss, T ... objs) {
        Assert.notNull(objs, "'objs' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.map = new HashMap<T, Integer>(objs.length, 1.0f);
        for (int i = 0; i < objs.length; ++i) {
            this.map.put(objs[i], i);
        }
    }

    @Override
    public int compare(T o1, T o2) {
        int index2;
        int index1 = this.getOrder(o1);
        if (index1 == (index2 = this.getOrder(o2))) {
            if (index1 < 0 || index1 == this.map.size()) {
                return 1;
            }
            return 0;
        }
        return Integer.compare(index1, index2);
    }

    private int getOrder(T object) {
        Integer order = this.map.get(object);
        if (order == null) {
            order = this.atEndIfMiss ? this.map.size() : -1;
        }
        return order;
    }
}

