/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.date.format;

import com.github.blackjack200.ouranos.shaded.hutool.core.date.DateUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.lang.Assert;
import com.github.blackjack200.ouranos.shaded.hutool.core.map.SafeConcurrentHashMap;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;

public class GlobalCustomFormat {
    public static final String FORMAT_SECONDS = "#sss";
    public static final String FORMAT_MILLISECONDS = "#SSS";
    private static final Map<CharSequence, Function<Date, String>> formatterMap = new SafeConcurrentHashMap<CharSequence, Function<Date, String>>();
    private static final Map<CharSequence, Function<CharSequence, Date>> parserMap = new SafeConcurrentHashMap<CharSequence, Function<CharSequence, Date>>();

    public static void putFormatter(String format, Function<Date, String> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        formatterMap.put(format, func);
    }

    public static void putParser(String format, Function<CharSequence, Date> func) {
        Assert.notNull(format, "Format must be not null !", new Object[0]);
        Assert.notNull(func, "Function must be not null !", new Object[0]);
        parserMap.put(format, func);
    }

    public static boolean isCustomFormat(String format) {
        return formatterMap.containsKey(format);
    }

    public static String format(Date date, CharSequence format) {
        Function<Date, String> func;
        if (null != formatterMap && null != (func = formatterMap.get(format))) {
            return func.apply(date);
        }
        return null;
    }

    public static String format(TemporalAccessor temporalAccessor, CharSequence format) {
        return GlobalCustomFormat.format(DateUtil.date(temporalAccessor), format);
    }

    public static Date parse(CharSequence dateStr, String format) {
        Function<CharSequence, Date> func;
        if (null != parserMap && null != (func = parserMap.get(format))) {
            return func.apply(dateStr);
        }
        return null;
    }

    static {
        GlobalCustomFormat.putFormatter(FORMAT_SECONDS, date -> String.valueOf(Math.floorDiv(date.getTime(), 1000L)));
        GlobalCustomFormat.putParser(FORMAT_SECONDS, dateStr -> DateUtil.date(Math.multiplyExact(Long.parseLong(dateStr.toString()), 1000L)));
        GlobalCustomFormat.putFormatter(FORMAT_MILLISECONDS, date -> String.valueOf(date.getTime()));
        GlobalCustomFormat.putParser(FORMAT_MILLISECONDS, dateStr -> DateUtil.date(Long.parseLong(dateStr.toString())));
    }
}

