/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v568;

import com.github.blackjack200.ouranos.shaded.fastutil.objects.ObjectArrayList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.EntityDataTypeMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v557.BedrockCodecHelper_v557;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.Ability;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ContainerSlotType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.TextProcessingEventOrigin;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.AnimationData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.ImageData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.PersonaPieceData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.PersonaPieceTintData;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.skin.SerializedSkin;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.TypeMap;
import io.netty.buffer.ByteBuf;

public class BedrockCodecHelper_v568
extends BedrockCodecHelper_v557 {
    public BedrockCodecHelper_v568(EntityDataTypeMap entityData, TypeMap<Class<?>> gameRulesTypes, TypeMap<ItemStackRequestActionType> stackRequestActionTypes, TypeMap<ContainerSlotType> containerSlotTypes, TypeMap<Ability> abilities, TypeMap<TextProcessingEventOrigin> textProcessingEventOrigins) {
        super(entityData, gameRulesTypes, stackRequestActionTypes, containerSlotTypes, abilities, textProcessingEventOrigins);
    }

    @Override
    public SerializedSkin readSkin(ByteBuf buffer) {
        String skinId = this.readString(buffer);
        String playFabId = this.readString(buffer);
        String skinResourcePatch = this.readString(buffer);
        ImageData skinData = this.readImage(buffer, 262144);
        ObjectArrayList<AnimationData> animations = new ObjectArrayList<AnimationData>();
        this.readArray(buffer, animations, ByteBuf::readIntLE, (ByteBuf b, BedrockCodecHelper h) -> this.readAnimationData((ByteBuf)b));
        ImageData capeData = this.readImage(buffer, 8192);
        String geometryData = this.readStringMaxLen(buffer, this.encodingSettings.maxGeometryDataSize());
        String geometryDataEngineVersion = this.readString(buffer);
        String animationData = this.readString(buffer);
        String capeId = this.readString(buffer);
        String fullSkinId = this.readString(buffer);
        String armSize = this.readString(buffer);
        String skinColor = this.readString(buffer);
        ObjectArrayList<PersonaPieceData> personaPieces = new ObjectArrayList<PersonaPieceData>();
        this.readArray(buffer, personaPieces, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceId = this.readString((ByteBuf)buf);
            String pieceType = this.readString((ByteBuf)buf);
            String packId = this.readString((ByteBuf)buf);
            boolean isDefault = buf.readBoolean();
            String productId = this.readString((ByteBuf)buf);
            return new PersonaPieceData(pieceId, pieceType, packId, isDefault, productId);
        });
        ObjectArrayList<PersonaPieceTintData> tintColors = new ObjectArrayList<PersonaPieceTintData>();
        this.readArray(buffer, tintColors, ByteBuf::readIntLE, (ByteBuf buf, BedrockCodecHelper h) -> {
            String pieceType = this.readString((ByteBuf)buf);
            ObjectArrayList<String> colors = new ObjectArrayList<String>();
            int colorsLength = buf.readIntLE();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.readString((ByteBuf)buf));
            }
            return new PersonaPieceTintData(pieceType, colors);
        });
        boolean premium = buffer.readBoolean();
        boolean persona = buffer.readBoolean();
        boolean capeOnClassic = buffer.readBoolean();
        boolean primaryUser = buffer.readBoolean();
        boolean overridingPlayerAppearance = buffer.readBoolean();
        return SerializedSkin.of(skinId, playFabId, skinResourcePatch, skinData, animations, capeData, geometryData, geometryDataEngineVersion, animationData, premium, persona, capeOnClassic, primaryUser, capeId, fullSkinId, armSize, skinColor, personaPieces, tintColors, overridingPlayerAppearance);
    }

    @Override
    public void writeSkin(ByteBuf buffer, SerializedSkin skin) {
        super.writeSkin(buffer, skin);
        buffer.writeBoolean(skin.isOverridingPlayerAppearance());
    }
}

