/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.codec.packet;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.PacketDirection;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodec;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.compat.BedrockCompat;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.PacketRecipient;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.netty.BedrockPacketWrapper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.BedrockPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.UnknownPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.Objects;

public abstract class BedrockPacketCodec
extends MessageToMessageCodec<ByteBuf, BedrockPacketWrapper> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(BedrockPacketCodec.class);
    public static final String NAME = "bedrock-packet-codec";
    private BedrockCodec codec = BedrockCompat.CODEC;
    private BedrockCodecHelper helper = this.codec.createHelper();
    private PacketRecipient inboundRecipient;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        PacketDirection attribute = (PacketDirection)((Object)ctx.channel().attr(PacketDirection.ATTRIBUTE).get());
        if (attribute != null) {
            this.inboundRecipient = attribute.getInbound();
        }
    }

    protected final void encode(ChannelHandlerContext ctx, BedrockPacketWrapper msg, List<Object> out) throws Exception {
        if (msg.getPacketBuffer() != null) {
            out.add((Object)msg.retain());
        } else {
            ByteBuf buf = ctx.alloc().buffer(128);
            try {
                BedrockPacket packet = msg.getPacket();
                msg.setPacketId(this.getPacketId(packet));
                this.encodeHeader(buf, msg);
                this.codec.tryEncode(this.helper, buf, packet);
                msg.setPacketBuffer(buf.retain());
                out.add((Object)msg.retain());
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("Error encoding packet {}", (Object)msg.getPacket(), (Object)t);
                }
                throw t;
            }
            finally {
                buf.release();
            }
        }
    }

    protected final void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        BedrockPacketWrapper wrapper = BedrockPacketWrapper.create();
        wrapper.setPacketBuffer(msg.retainedSlice());
        try {
            int index = msg.readerIndex();
            this.decodeHeader(msg, wrapper);
            wrapper.setHeaderLength(msg.readerIndex() - index);
            wrapper.setPacket(this.codec.tryDecode(this.helper, msg, wrapper.getPacketId(), this.inboundRecipient));
            out.add((Object)wrapper.retain());
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to decode packet", t);
            }
            throw t;
        }
        finally {
            wrapper.release();
        }
    }

    public abstract void encodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    public abstract void decodeHeader(ByteBuf var1, BedrockPacketWrapper var2);

    public final int getPacketId(BedrockPacket packet) {
        if (packet instanceof UnknownPacket) {
            return ((UnknownPacket)packet).getPacketId();
        }
        return this.codec.getPacketDefinition(packet.getClass()).getId();
    }

    public final void setCodec(BedrockCodec codec) {
        this.codec = Objects.requireNonNull(codec, "Codec cannot be null");
        this.helper = codec.createHelper();
    }

    public final BedrockCodec getCodec() {
        return this.codec;
    }

    public BedrockCodecHelper getHelper() {
        return this.helper;
    }
}

