/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.translators.new_to_old.v419to408;

import com.github.blackjack200.ouranos.base.ProtocolToProtocol;
import com.github.blackjack200.ouranos.converter.BlockStateDictionary;
import com.github.blackjack200.ouranos.data.LegacyBlockIdToStringIdMap;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponseStatus;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ItemStackResponsePacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.PlayerAuthInputPacket;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.StartGamePacket;
import java.util.List;
import java.util.Objects;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;

public class Protocol419to408
extends ProtocolToProtocol {
    @Override
    protected void registerProtocol() {
        this.registerClientbound(ItemStackResponsePacket.class, wrapped -> {
            ItemStackResponsePacket packet = (ItemStackResponsePacket)wrapped.getPacket();
            packet.getEntries().replaceAll(entry -> new ItemStackResponse(entry.getResult().equals((Object)ItemStackResponseStatus.OK), entry.getRequestId(), entry.getContainers()));
        });
        this.registerClientbound(StartGamePacket.class, wrapped -> {
            StartGamePacket packet = (StartGamePacket)wrapped.getPacket();
            List<NbtMap> states = BlockStateDictionary.getInstance(wrapped.getOutput()).getKnownStates().stream().map(e -> {
                short legacyId = (short)(Objects.requireNonNullElse(LegacyBlockIdToStringIdMap.getInstance().fromString(wrapped.getOutput(), e.name()), 255) & 0xFFFFFFF);
                return NbtMap.builder().putCompound("block", e.rawState()).putShort("id", legacyId).build();
            }).toList();
            packet.setBlockPalette((NbtList<NbtMap>)new NbtList(NbtType.COMPOUND, states));
        });
        this.registerServerbound(PlayerAuthInputPacket.class, wrapped -> {
            PlayerAuthInputPacket packet = (PlayerAuthInputPacket)wrapped.getPacket();
            packet.setDelta(Vector3f.ZERO);
        });
    }
}

