/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.utils;

import com.github.blackjack200.ouranos.utils.binary.BinaryStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class VarInt {
    private VarInt() {
    }

    public static long encodeZigZag32(int v) {
        return (long)(v << 1 ^ v >> 31) & 0xFFFFFFFFL;
    }

    public static int decodeZigZag32(long v) {
        return (int)(v >> 1) ^ -((int)(v & 1L));
    }

    public static long encodeZigZag64(long v) {
        return v << 1 ^ v >> 63;
    }

    public static long decodeZigZag64(long v) {
        return v >>> 1 ^ -(v & 1L);
    }

    private static long read(BinaryStream stream, int maxSize) {
        int b;
        long value = 0L;
        int size = 0;
        while (((b = stream.getByte()) & 0x80) == 128) {
            value |= (long)(b & 0x7F) << size++ * 7;
            if (size < maxSize) continue;
            throw new IllegalArgumentException("VarLong too big");
        }
        return value | (long)(b & 0x7F) << size * 7;
    }

    private static long read(InputStream stream, int maxSize) throws IOException {
        int b;
        long value = 0L;
        int size = 0;
        while (((b = stream.read()) & 0x80) == 128) {
            value |= (long)(b & 0x7F) << size++ * 7;
            if (size < maxSize) continue;
            throw new IllegalArgumentException("VarLong too big");
        }
        return value | (long)(b & 0x7F) << size * 7;
    }

    public static int readVarInt(BinaryStream stream) {
        return VarInt.decodeZigZag32(VarInt.readUnsignedVarInt(stream));
    }

    public static int readVarInt(InputStream stream) throws IOException {
        return VarInt.decodeZigZag32(VarInt.readUnsignedVarInt(stream));
    }

    public static long readUnsignedVarInt(BinaryStream stream) {
        return VarInt.read(stream, 5);
    }

    public static long readUnsignedVarInt(InputStream stream) throws IOException {
        return VarInt.read(stream, 5);
    }

    public static long readVarLong(BinaryStream stream) {
        return VarInt.decodeZigZag64(VarInt.readUnsignedVarLong(stream));
    }

    public static long readVarLong(InputStream stream) throws IOException {
        return VarInt.decodeZigZag64(VarInt.readUnsignedVarLong(stream));
    }

    public static long readUnsignedVarLong(BinaryStream stream) {
        return VarInt.read(stream, 10);
    }

    public static long readUnsignedVarLong(InputStream stream) throws IOException {
        return VarInt.read(stream, 10);
    }

    private static void write(BinaryStream stream, long value) {
        do {
            byte temp = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                temp = (byte)(temp | 0x80);
            }
            stream.putByte(temp);
        } while (value != 0L);
    }

    private static void write(OutputStream stream, long value) throws IOException {
        do {
            byte temp = (byte)(value & 0x7FL);
            if ((value >>>= 7) != 0L) {
                temp = (byte)(temp | 0x80);
            }
            stream.write(temp);
        } while (value != 0L);
    }

    public static void writeVarInt(BinaryStream stream, int value) {
        VarInt.writeUnsignedVarInt(stream, VarInt.encodeZigZag32(value));
    }

    public static void writeVarInt(OutputStream stream, int value) throws IOException {
        VarInt.writeUnsignedVarInt(stream, VarInt.encodeZigZag32(value));
    }

    public static void writeUnsignedVarInt(BinaryStream stream, long value) {
        VarInt.write(stream, value);
    }

    public static void writeUnsignedVarInt(OutputStream stream, long value) throws IOException {
        VarInt.write(stream, value);
    }

    public static void writeVarLong(BinaryStream stream, long value) {
        VarInt.writeUnsignedVarLong(stream, VarInt.encodeZigZag64(value));
    }

    public static void writeVarLong(OutputStream stream, long value) throws IOException {
        VarInt.writeUnsignedVarLong(stream, VarInt.encodeZigZag64(value));
    }

    public static void writeUnsignedVarLong(BinaryStream stream, long value) {
        VarInt.write(stream, value);
    }

    public static void writeUnsignedVarLong(OutputStream stream, long value) throws IOException {
        VarInt.write(stream, value);
    }
}

