/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion;

import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v575.Bedrock_v575;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.cloudburstmc.netty.channel.raknet.RakChannelFactory;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodec;
import org.cloudburstmc.protocol.bedrock.codec.v818.Bedrock_v818;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.lifecycle.GeyserPostInitializeEvent;
import org.geysermc.geyser.api.event.lifecycle.GeyserPreInitializeEvent;
import org.geysermc.geyser.api.extension.Extension;
import org.geysermc.geyser.api.extension.ExtensionLogger;
import org.geysermc.geyser.configuration.GeyserConfiguration;
import org.geysermc.geyser.network.netty.Bootstraps;
import org.geysermc.geyser.network.netty.GeyserServer;
import org.geysermc.geyser.network.netty.handler.RakConnectionRequestHandler;
import org.geysermc.geyser.network.netty.handler.RakGeyserRateLimiter;
import org.geysermc.geyser.network.netty.handler.RakPingHandler;
import org.geysermc.geyser.network.netty.proxy.ProxyServerHandler;
import org.geysermc.mcprotocollib.network.helper.TransportHelper;
import oxy.geyser.reversion.config.Config;
import oxy.geyser.reversion.config.ConfigLoader;
import oxy.geyser.reversion.handler.init.TranslatorServerInitializer;
import oxy.geyser.reversion.shaded.classtransform.TransformerManager;
import oxy.geyser.reversion.shaded.reflect.Agents;
import oxy.geyser.reversion.transformer.BaseBedrockCodecHelperTransformer;
import oxy.geyser.reversion.util.CodecUtil;
import oxy.geyser.reversion.util.GeyserExtensionClassProvider;
import oxy.geyser.reversion.util.PendingBedrockAuthentication;

public class GeyserReversion
implements Extension {
    public static ExtensionLogger LOGGER;
    public static BedrockCodec OLDEST_GEYSER_CODEC;
    private static final TransportHelper.TransportType TRANSPORT;
    public static PendingBedrockAuthentication AUTH;
    public static Config CONFIG;
    public static boolean INJECTION_FAILED;

    @Subscribe
    public void onGeyserPreInitializeEvent(GeyserPreInitializeEvent event) {
        LOGGER = this.logger();
        try {
            TransformerManager transformerManager = new TransformerManager(new GeyserExtensionClassProvider());
            transformerManager.addTransformer(BaseBedrockCodecHelperTransformer.class.getName());
            transformerManager.hookInstrumentation(Agents.getInstrumentation());
        }
        catch (Exception e) {
            INJECTION_FAILED = true;
            throw new RuntimeException("CODE INJECTION FAILED! ANY VERSION BELOW " + Bedrock_v575.CODEC.getMinecraftVersion() + " WILL NOT BE SUPPORTED!", e);
        }
    }

    @Subscribe
    public void onGeyserPostInitializeEvent(GeyserPostInitializeEvent event) {
        CONFIG = ConfigLoader.load(this, GeyserReversion.class, Config.class);
        GeyserImpl geyser = GeyserImpl.getInstance();
        geyser.getGeyserServer().shutdown();
        Integer bedrockThreadCount = Integer.getInteger("Geyser.BedrockNetworkThreads");
        if (bedrockThreadCount == null) {
            bedrockThreadCount = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));
        }
        EventLoopGroup group = (EventLoopGroup)TRANSPORT.eventLoopGroupFactory().apply(Bootstraps.isReusePortAvailable() ? Integer.getInteger("Geyser.ListenCount", 1) : 1, new DefaultThreadFactory("GeyserServer", true));
        EventLoopGroup childGroup = (EventLoopGroup)TRANSPORT.eventLoopGroupFactory().apply(bedrockThreadCount, new DefaultThreadFactory("GeyserServerChild", true));
        TranslatorServerInitializer serverInitializer = new TranslatorServerInitializer(geyser);
        int rakPacketLimit = this.positivePropOrDefault("Geyser.RakPacketLimit", 120);
        int rakGlobalPacketLimit = this.positivePropOrDefault("Geyser.RakGlobalPacketLimit", 100000);
        boolean rakSendCookie = Boolean.parseBoolean(System.getProperty("Geyser.RakSendCookie", "true"));
        ServerBootstrap bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory((ChannelFactory)RakChannelFactory.server((Class)TRANSPORT.datagramChannelClass()))).group(group, childGroup).option(RakChannelOption.RAK_HANDLE_PING, (Object)true)).option(RakChannelOption.RAK_MAX_MTU, (Object)geyser.getConfig().getMtu())).option(RakChannelOption.RAK_PACKET_LIMIT, (Object)rakPacketLimit)).option(RakChannelOption.RAK_GLOBAL_PACKET_LIMIT, (Object)rakGlobalPacketLimit)).option(RakChannelOption.RAK_SEND_COOKIE, (Object)rakSendCookie)).childHandler((ChannelHandler)serverInitializer);
        Bootstraps.setupBootstrap((AbstractBootstrap)bootstrap);
        Field field = GeyserServer.class.getDeclaredField("bootstrapFutures");
        field.setAccessible(true);
        GeyserConfiguration config = geyser.getConfig();
        ChannelFuture[] futures = (ChannelFuture[])field.get(geyser.getGeyserServer());
        for (int i = 0; i < futures.length; ++i) {
            ChannelFuture future = bootstrap.bind((SocketAddress)new InetSocketAddress(config.getBedrock().address(), config.getBedrock().port()));
            this.modifyHandlers(future);
            futures[i] = future;
        }
        Bootstraps.allOf((ChannelFuture[])futures).join();
        Field groupField = GeyserServer.class.getDeclaredField("group");
        groupField.setAccessible(true);
        groupField.set(geyser.getGeyserServer(), group);
        Field childGroupField = GeyserServer.class.getDeclaredField("childGroup");
        childGroupField.setAccessible(true);
        childGroupField.set(geyser.getGeyserServer(), childGroup);
        Field playerGroupField = GeyserServer.class.getDeclaredField("playerGroup");
        playerGroupField.setAccessible(true);
        playerGroupField.set(geyser.getGeyserServer(), serverInitializer.getEventLoopGroup());
    }

    private void modifyHandlers(ChannelFuture future) {
        boolean isWhitelistedProxyProtocol;
        Channel channel = future.channel();
        channel.pipeline().addFirst("rak-connection-request-handler", (ChannelHandler)new RakConnectionRequestHandler(GeyserImpl.getInstance().getGeyserServer())).addAfter("rak-offline-handler", "rak-ping-handler", (ChannelHandler)new RakPingHandler(GeyserImpl.getInstance().getGeyserServer()));
        boolean isProxyProtocol = GeyserImpl.getInstance().getConfig().getBedrock().isEnableProxyProtocol();
        if (isProxyProtocol) {
            channel.pipeline().addFirst("proxy-protocol-decoder", (ChannelHandler)new ProxyServerHandler());
        }
        boolean bl = isWhitelistedProxyProtocol = isProxyProtocol && !GeyserImpl.getInstance().getConfig().getBedrock().getProxyProtocolWhitelistedIPs().isEmpty();
        if (Boolean.parseBoolean(System.getProperty("Geyser.RakRateLimitingDisabled", "false")) || isWhitelistedProxyProtocol) {
            channel.pipeline().remove("rak-server-rate-limiter");
        } else {
            channel.pipeline().replace("rak-server-rate-limiter", "rak-geyser-rate-limiter", (ChannelHandler)new RakGeyserRateLimiter(channel));
        }
    }

    private int positivePropOrDefault(String property, int defaultValue) {
        String value = System.getProperty(property);
        try {
            int parsed;
            int n = parsed = value != null ? Integer.parseInt(value) : defaultValue;
            if (parsed < 1) {
                GeyserImpl.getInstance().getLogger().warning("Non-postive integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
                return defaultValue;
            }
            return parsed;
        }
        catch (NumberFormatException e) {
            GeyserImpl.getInstance().getLogger().warning("Invalid integer value for " + property + ": " + value + ". Using default value: " + defaultValue);
            return defaultValue;
        }
    }

    static {
        OLDEST_GEYSER_CODEC = CodecUtil.rebuildCodec(Bedrock_v818.CODEC);
        TRANSPORT = TransportHelper.TRANSPORT_TYPE;
        AUTH = new PendingBedrockAuthentication();
        INJECTION_FAILED = false;
    }
}

