/*
 * Decompiled with CFR 0.152.
 */
package oxy.geyser.reversion.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import oxy.geyser.reversion.shaded.jackson.core.JsonGenerator;
import oxy.geyser.reversion.shaded.jackson.databind.JavaType;
import oxy.geyser.reversion.shaded.jackson.databind.JsonMappingException;
import oxy.geyser.reversion.shaded.jackson.databind.SerializerProvider;
import oxy.geyser.reversion.shaded.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import oxy.geyser.reversion.shaded.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import oxy.geyser.reversion.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import oxy.geyser.reversion.shaded.jackson.databind.ser.std.StdScalarSerializer;
import oxy.geyser.reversion.shaded.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

