/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.converter;

import com.github.blackjack200.ouranos.converter.ItemIdentifierConverter;
import com.github.blackjack200.ouranos.converter.ItemTypeDictionary;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.definitions.ItemDefinition;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.inventory.ItemData;
import com.github.blackjack200.ouranos.utils.SimpleBlockDefinition;
import java.util.Objects;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;

public class ItemTranslator {
    public static final String POLYFILL_ITEM_TAG = "____Ouranos____";

    public static ItemData recoverPolyfillItem(ItemData itemData) {
        NbtMap polyfillData = itemData.getTag().getCompound(POLYFILL_ITEM_TAG);
        if (polyfillData != NbtMap.EMPTY) {
            ItemTypeDictionary.InnerEntry itemDict = ItemTypeDictionary.getInstance(polyfillData.getInt("Source"));
            ItemData.Builder builder = ItemData.builder().definition(itemDict.getEntries().get(itemDict.fromIntId(polyfillData.getInt("ItemId"))).toDefinition(polyfillData.getString("StringId"))).tag(polyfillData.getCompound("Nbt")).count(itemData.getCount()).damage(polyfillData.getInt("Meta")).netId(itemData.getNetId()).canBreak(itemData.getCanBreak()).canPlace(itemData.getCanPlace()).blockingTicks(itemData.getBlockingTicks()).usingNetId(polyfillData.getBoolean("UsingNetId")).netId(polyfillData.getInt("NetId"));
            if (polyfillData.containsKey((Object)"BlockId")) {
                builder.blockDefinition(new SimpleBlockDefinition(polyfillData.getInt("BlockId")));
            }
            return builder.build();
        }
        return null;
    }

    public static ItemData makePolyfillItem(int input, int output, ItemData itemData) {
        String mappedIdentifier;
        String oldIdentifier = itemData.getDefinition().getIdentifier();
        String finalIdentifier = Objects.equals(oldIdentifier, mappedIdentifier = ItemIdentifierConverter.translate(oldIdentifier, input, output)) || ItemTypeDictionary.getInstance(output).getEntries().get(mappedIdentifier) == null ? (itemData.getBlockDefinition() == null || itemData.getBlockDefinition().getRuntimeId() == 0 ? "minecraft:paper" : "minecraft:barrier") : mappedIdentifier;
        ItemDefinition def = itemData.getDefinition();
        ItemData.Builder polyfillItem = ItemData.builder().usingNetId(itemData.isUsingNetId()).netId(itemData.getNetId()).count(itemData.getCount()).damage(0).tag(itemData.getTag()).definition(ItemTypeDictionary.getInstance(output).getEntries().get(finalIdentifier).toDefinition(finalIdentifier));
        NbtMapBuilder polyfillData = NbtMap.builder().putInt("Source", input).putInt("Meta", itemData.getDamage()).putString("StringId", def.getIdentifier()).putBoolean("UsingNetId", itemData.isUsingNetId()).putInt("NetId", itemData.getNetId()).putString("StringId", def.getIdentifier()).putInt("ItemId", def.getRuntimeId());
        if (itemData.getBlockDefinition() != null) {
            polyfillData.putInt("BlockId", itemData.getBlockDefinition().getRuntimeId());
        }
        if (itemData.getTag() != null) {
            polyfillData.putCompound("Nbt", itemData.getTag());
        }
        polyfillItem.tag(NbtMap.builder().putCompound("display", NbtMap.builder().putString("Name", def.getIdentifier()).build()).putCompound(POLYFILL_ITEM_TAG, polyfillData.build()).build());
        return polyfillItem.build();
    }
}

