/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.hutool.core.annotation;

import com.github.blackjack200.ouranos.shaded.hutool.core.annotation.AnnotationUtil;
import com.github.blackjack200.ouranos.shaded.hutool.core.map.TableMap;
import com.github.blackjack200.ouranos.shaded.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class CombinationAnnotationElement
implements AnnotatedElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<? extends Annotation>, Annotation> annotationMap;
    private Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap;
    private final Predicate<Annotation> predicate;

    public static CombinationAnnotationElement of(AnnotatedElement element, Predicate<Annotation> predicate) {
        return new CombinationAnnotationElement(element, predicate);
    }

    public CombinationAnnotationElement(AnnotatedElement element) {
        this(element, null);
    }

    public CombinationAnnotationElement(AnnotatedElement element, Predicate<Annotation> predicate) {
        this.predicate = predicate;
        this.init(element);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.annotationMap.containsKey(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation = this.annotationMap.get(annotationClass);
        return (T)(annotation == null ? null : annotation);
    }

    @Override
    public Annotation[] getAnnotations() {
        Collection<Annotation> annotations = this.annotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Collection<Annotation> annotations = this.declaredAnnotationMap.values();
        return annotations.toArray(new Annotation[0]);
    }

    private void init(AnnotatedElement element) {
        Annotation[] declaredAnnotations = element.getDeclaredAnnotations();
        this.declaredAnnotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
        this.parseDeclared(declaredAnnotations);
        Annotation[] annotations = element.getAnnotations();
        if (declaredAnnotations.length == annotations.length) {
            this.annotationMap = this.declaredAnnotationMap;
        } else {
            this.annotationMap = new TableMap<Class<? extends Annotation>, Annotation>();
            this.parse(annotations);
        }
    }

    private void parseDeclared(Annotation[] annotations) {
        if (ArrayUtil.isEmpty(annotations)) {
            return;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!AnnotationUtil.isNotJdkMateAnnotation(annotationType) || this.declaredAnnotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.declaredAnnotationMap.put(annotationType, annotation);
            }
            this.parseDeclared(annotationType.getDeclaredAnnotations());
        }
    }

    private void parse(Annotation[] annotations) {
        if (ArrayUtil.isEmpty(annotations)) {
            return;
        }
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!AnnotationUtil.isNotJdkMateAnnotation(annotationType) || this.annotationMap.containsKey(annotationType)) continue;
            if (this.test(annotation)) {
                this.annotationMap.put(annotationType, annotation);
            }
            this.parse(annotationType.getAnnotations());
        }
    }

    private boolean test(Annotation annotation) {
        return null == this.predicate || this.predicate.test(annotation);
    }
}

