/*
 * Decompiled with CFR 0.152.
 */
package com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v544.serializer;

import com.github.blackjack200.ouranos.shaded.fastutil.longs.LongList;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.BedrockCodecHelper;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.codec.v354.serializer.ClientboundMapItemDataSerializer_v354;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.MapDecoration;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.data.MapTrackedObject;
import com.github.blackjack200.ouranos.shaded.protocol.bedrock.packet.ClientboundMapItemDataPacket;
import com.github.blackjack200.ouranos.shaded.protocol.common.util.VarInts;
import io.netty.buffer.ByteBuf;
import java.util.List;

public class ClientboundMapItemDataSerializer_v544
extends ClientboundMapItemDataSerializer_v354 {
    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        LongList trackedEntityIds;
        VarInts.writeLong(buffer, packet.getUniqueMapId());
        int type = 0;
        int[] colors = packet.getColors();
        if (colors != null && colors.length > 0) {
            type |= 2;
        }
        List<MapDecoration> decorations = packet.getDecorations();
        List<MapTrackedObject> trackedObjects = packet.getTrackedObjects();
        if (!decorations.isEmpty() && !trackedObjects.isEmpty()) {
            type |= 4;
        }
        if (!(trackedEntityIds = packet.getTrackedEntityIds()).isEmpty()) {
            type |= 8;
        }
        VarInts.writeUnsignedInt(buffer, type);
        buffer.writeByte(packet.getDimensionId());
        buffer.writeBoolean(packet.isLocked());
        helper.writeVector3i(buffer, packet.getOrigin());
        if ((type & 8) != 0) {
            this.writeMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            buffer.writeByte(packet.getScale());
        }
        if ((type & 4) != 0) {
            this.writeMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.writeTextureUpdate(buffer, helper, packet);
        }
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, ClientboundMapItemDataPacket packet) {
        packet.setUniqueMapId(VarInts.readLong(buffer));
        int type = VarInts.readUnsignedInt(buffer);
        packet.setDimensionId(buffer.readUnsignedByte());
        packet.setLocked(buffer.readBoolean());
        packet.setOrigin(helper.readVector3i(buffer));
        if ((type & 8) != 0) {
            this.readMapCreation(buffer, helper, packet);
        }
        if ((type & 0xE) != 0) {
            packet.setScale(buffer.readUnsignedByte());
        }
        if ((type & 4) != 0) {
            this.readMapDecorations(buffer, helper, packet);
        }
        if ((type & 2) != 0) {
            this.readTextureUpdate(buffer, helper, packet);
        }
    }
}

